#include "stdafx.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDockWidget>
#include <QMainWindow>
#include <QPushButton>

#include "dsMenuItem_c.h"
#include "dsToolbar_c.h"
#include "dsCommandMessage_c.h"

#include "Options.h"
#include "miscellaneous.h"
#include "BlockLibraryManager.h"
#include "dsAddinConnection.h"

BlockLibraryManagerApplication *globalBlockLibraryManager = 0;
const dsString BlockLibraryManagerApplication::appID = L"FEC2DA7E-79F7-4B4A-8F27-220A67BDBD77";

bool BlockLibraryManagerApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandSetLibraryRootPath.createAndRegisterCommand();
    m_CommandDialog.createAndRegisterCommand();
    m_CommandShow.createAndRegisterCommand();
    m_CommandHide.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    m_dsApp->AddMenu(
        BlockLibraryManagerApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"BlockLibraryManager",
        &menu);
    if (!menu)
        return false;
    dsMenuItem_ptr menu_item;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    m_dsApp->AddToolbar(
        BlockLibraryManagerApplication::appID,
        dsUIState_Document,
        L"BlockLibraryManager",
        &toolbar);
    if (!toolbar)
        return false;
    dsToolbarItem_ptr toolbar_item;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also create a new menu.

    m_CommandSetLibraryRootPath.createUserCommand();
    m_CommandSetLibraryRootPath.insert(menu, menu_position++);
    m_CommandSetLibraryRootPath.insert(toolbar, toolbar_position++);

    m_CommandDialog.createUserCommand();
    m_CommandDialog.insert(menu, menu_position++);
    m_CommandDialog.insert(toolbar, toolbar_position++);

    m_CommandShow.createUserCommand();
    m_CommandShow.insert(menu, menu_position++);
    m_CommandShow.insert(toolbar, toolbar_position++);

    m_CommandHide.createUserCommand();
    m_CommandHide.insert(menu, menu_position++);
    m_CommandHide.insert(toolbar, toolbar_position++);

    return CreateDockWidget();
}

bool BlockLibraryManagerApplication::CreateDockWidget()
{
    DSRESULT r = m_dsApp->CreateCustomPropertyControl2(
        q2d(Options::instance().DockWidgetName),
        dsCustomPropertyControlArea_Right,
        dsCustomPropertyControlArea_Left | dsCustomPropertyControlArea_Right,
        &m_dockwidget);

    Options::instance().dockwidget = m_dockwidget;
    if (r != DSRESULT_True || !m_dockwidget)
        return false;

    // Although HWND is Windows-specific vocabulary,
    // this should work platform-independently.
    long handle = 0;
    m_dockwidget->GetHWND(&handle);
    QWidget *widget = QWidget::find((WId)handle);

    // Can that happen?
    if (!widget)
        return false;

    // Fill the dock widget with life, i.e. put our block library widget
    // inside, add an 'Insert' button, a help button and connect signals
    // in order to get everything to function.
    m_block_library_widget = new BlockLibraryWidget(widget);
    m_block_library_widget->setLibraryRoot(Options::instance().library_root_path);
    QPushButton *bt_insert = new QPushButton;
    bt_insert->setText(tr("Insert"));
    QPushButton *bt_help = new QPushButton;
    bt_help->setText(tr("Help"));
    QHBoxLayout *hbox = new QHBoxLayout;
    hbox->addWidget(bt_insert);
    hbox->addWidget(bt_help);
    QVBoxLayout *vbox = new QVBoxLayout;
    vbox->addWidget(m_block_library_widget);
    vbox->addLayout(hbox);
    widget->setLayout(vbox);
    widget->show();
    m_dockwidget->put_Visible(true);
    m_CommandSetLibraryRootPath.setBlockLibraryWidget(m_block_library_widget);
    connect(bt_insert, SIGNAL(clicked()), this, SLOT(on_insert()));
    //connect(bt_help, SIGNAL(clicked()), this, SLOT(on_help()));

    // Return true, if m_block_library_widget was created.
    return m_block_library_widget;
}

void BlockLibraryManagerApplication::on_insert()
{
    if (!m_block_library_widget)
        return;

    // Insert all selected blocks.
    BlockLibraryManager manager(
        m_dsApp,
        m_block_library_widget->getSelectedDrawings(),
        m_block_library_widget->scaleX(),
        m_block_library_widget->scaleY(),
        m_block_library_widget->scaleZ(),
        m_block_library_widget->rotation(),
        m_block_library_widget->specifyScaleLater(),
        m_block_library_widget->specifyRotationLater());
    manager.insert();
}

#ifdef DS_WIN
BlockLibraryManager_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" BlockLibraryManager_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalBlockLibraryManager)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = BlockLibraryManagerApplication::appID;
        globalBlockLibraryManager = new BlockLibraryManagerApplication(dsApp);
        return globalBlockLibraryManager->CreateUserInterfaceAndCommands();
    }
    return false;
}

#ifdef DS_WIN
BlockLibraryManager_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" BlockLibraryManager_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalBlockLibraryManager)
    {
        if (globalBlockLibraryManager->getDsApp())
        {
            globalBlockLibraryManager->getDsApp()->RemoveUserInterface(
                BlockLibraryManagerApplication::appID);
        }
        delete globalBlockLibraryManager;
        globalBlockLibraryManager = 0;
    }

    return true;
}

#ifdef DS_WIN
BlockLibraryManager_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" BlockLibraryManager_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"0B6D56A7-4434-4e12-ACFA-633196183A03" );
    return true;
}
