#include <QList>
#include <QVector>
#include <QApplication>

#include "miscellaneous.h"

#ifdef Q_OS_WIN
#include "Windows.h"
#else
#include <stdlib.h>
#endif

int setEnvironmentVariable(
    const QString &variable,
    const QString &value /*= QString()*/)
{
#ifdef Q_OS_WIN
    QVector<wchar_t> var(variable.size() + 1, 0);
    variable.toWCharArray(var.data());
    QVector<wchar_t> val(value.size() + 1, 0);
    value.toWCharArray(val.data());
    return (int)SetEnvironmentVariable(var.data(), val.data());
#else
    return (int)setenv(
        variable.toStdString().c_str(),
        value.toStdString().c_str(),
        true);
#endif
}

QString getEnvironmentVariable( const QString &variable )
{
#ifdef Q_OS_WIN
    QVector<wchar_t> var(variable.size() + 1, 0);
    variable.toWCharArray(var.data());
    QVector<wchar_t> value(1024);
    GetEnvironmentVariable(
        (LPCWSTR)var.data(), (LPWSTR)value.data(), value.size());
    return QString::fromWCharArray(value.data());
#else
    return QString::fromLatin1(getenv( variable.toStdString().c_str() ));
#endif
}

dsString q2d( const QString &s )
{
    return dsString( s.toStdWString().c_str() );
}

dsStringArray q2d( const QStringList &l )
{
    dsStringArray result;
    foreach (QString s, l)
    {
        result.add(q2d(s));
    }
    return result;
}

dsByteArray q2d( const QByteArray &a )
{
    dsByteArray result;
    unsigned int l = (unsigned int)a.size();
    result.setSize(l);
    for (unsigned int i = 0; i < l; ++i)
        result[i] = a[i];
    return result;
}

QString d2q( const dsString &s )
{
    return QString::fromWCharArray((const wchar_t*)s);
}

QStringList d2q( const dsStringArray &l )
{
    QStringList result;
    for (unsigned int i = 0; i < l.getSize(); ++i)
        result << d2q(l[i]);
    return result;
}

QByteArray d2q( const dsByteArray &a )
{
    QByteArray result;
    unsigned int l = a.getSize();
    result.resize((int)l);
    for (unsigned int i = 0; i < l; ++i)
        result[(int)i] = a[i];
    return result;
}
