#include "../miscellaneous.h"
#include "../Options.h"
#include "BlockLibraryWidget.h"

BlockLibraryWidget::BlockLibraryWidget(QWidget *parent /*= 0*/)
: QWidget(parent)
, application(Options::instance().application)
, m_dwg_filter(QString::fromLatin1(
               "*.dwg,*.Dwg,*.dWg,*.DWg,*.dwG,*.DwG,*.dWG,*.DWG,"
               "*.dxf,*.Dxf,*.dXf,*.DXf,*.dxF,*.DxF,*.dXF,*.DXF").split(","))
{
    ui.setupUi(this);
}

void BlockLibraryWidget::setLibraryRoot( const QString &path )
{
    m_selected_drawings.clear();
    QDir dir(path);
    if (dir.exists())
    {
        QModelIndex i = m_library_model.setRootPath(path);
        ui.tree_libraries->setModel(&m_library_model);
        ui.tree_libraries->setRootIndex(i);
        ui.tree_libraries->hideColumn(1);
        ui.tree_libraries->hideColumn(2);
        ui.tree_libraries->hideColumn(3);
        on_tree_libraries_clicked(i);
    } 
}

void BlockLibraryWidget::on_tree_libraries_clicked( const QModelIndex & index )
{
    m_selected_drawings.clear();
    m_current_directory.clear();
    QFileInfo info = m_library_model.fileInfo(index);
    if (info.isDir())
    {
        ui.list_drawings->clear();
        m_current_directory = info.absoluteFilePath();
        QDir dir(m_current_directory);

        // Populate view_drawings:
        // This may take some time, and it is done each time anew, so for
        // better performance, the tree view should be preloaded.
        QStringList l = dir.entryList(m_dwg_filter, QDir::Files, QDir::Name);
        for (int i = 0; i < l.size(); i++)
        {
            // Retrieve a preview bitmap of the drawings
            QString filename_dwg = QString::fromLatin1("%1/%2")
                .arg(m_current_directory)
                .arg(l[i]);
            long w = 0, h = 0;
            dsByteArray data;
            bool preview_retrieved = false;
            application->GetPreviewBitmapBytes(
                q2d(filename_dwg),
                dsBitmapFormat_BMP,
                &w,
                &h,
                &data,
                &preview_retrieved);

            // Add new item ...
            QListWidgetItem *item = new QListWidgetItem(l[i]);
            item->setToolTip(filename_dwg);

            // ... and if there are image data,
            // draw them as an icon onto the item.
            if (preview_retrieved && data.getSize() > 0)
            {
                item->setIcon(QIcon(QPixmap::fromImage(QImage::fromData(
                    d2q(data)))));
            }

            // The list view becomes the owner of the item.
            ui.list_drawings->addItem(item);
        }
    }
}

void BlockLibraryWidget::on_list_drawings_itemSelectionChanged()
{
    // Re-populate m_selected_drawings
    m_selected_drawings.clear();
    QList<QListWidgetItem*> selection = ui.list_drawings->selectedItems();
    for (int i = 0; i< selection.size(); i++)
    {
        m_selected_drawings << QString::fromLatin1("%1/%2")
            .arg(m_current_directory)
            .arg(selection[i]->text());
    }
}

void BlockLibraryWidget::on_ch_scale_clicked()
{
    ui.ed_scale_x->setEnabled(!ui.ch_scale->isChecked());
    ui.ed_scale_y->setEnabled(!ui.ch_scale->isChecked());
    ui.ed_scale_z->setEnabled(!ui.ch_scale->isChecked());
}

void BlockLibraryWidget::on_ch_rotation_clicked()
{
    ui.ed_rotation->setEnabled(!ui.ch_rotation->isChecked());
}
