#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

BlockTrackerDemoApplication *globalBlockTrackerDemo = 0;
const dsString BlockTrackerDemoApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void BlockTrackerDemoApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandBlockTrackerDemo.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        BlockTrackerDemoApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"BlockTrackerDemo",
        &menu);
    if (!menu)
        return;
    dsMenuItem_ptr menu_item;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        BlockTrackerDemoApplication::appID,
        dsUIState_Document,
        L"BlockTrackerDemo",
        &toolbar);
    if (!toolbar)
        return;
    dsToolbarItem_ptr toolbar_item;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also create a new menu.

    m_CommandBlockTrackerDemo.createUserCommand();
    m_CommandBlockTrackerDemo.insert(menu, menu_position++);
    m_CommandBlockTrackerDemo.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
BlockTrackerDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" BlockTrackerDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalBlockTrackerDemo)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = BlockTrackerDemoApplication::appID;
        globalBlockTrackerDemo = new BlockTrackerDemoApplication(dsApp);
        globalBlockTrackerDemo->CreateUserInterfaceAndCommands();
    }
    return globalBlockTrackerDemo;
}

#ifdef DS_WIN
BlockTrackerDemo_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" BlockTrackerDemo_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalBlockTrackerDemo)
    {
        if (globalBlockTrackerDemo->getDsApp())
        {
             globalBlockTrackerDemo->getDsApp()->RemoveUserInterface(
                 BlockTrackerDemoApplication::appID);
        }
        delete globalBlockTrackerDemo;
        globalBlockTrackerDemo = 0;
    }
    return true;
}

#ifdef DS_WIN
BlockTrackerDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" BlockTrackerDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"A085E761-D046-4f6b-BFA2-02F0DDD1B10E" );
    return true;
}
