#include "stdafx.h"
#include "dsCommandMessage_c.h"
#include "Options.h"
#include "miscellaneous.h"
#include "dsAddinConnection.h"

LispSampleApplication *globalLispSample = 0;
const dsString LispSampleApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void LispSampleApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandRegister.createAndRegisterCommand();
    m_CommandUnregister.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int MENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        LispSampleApplication::appID,
        dsUIState_Document,
        MENU_POSITION,
        L"LispSample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    dsToolbar_ptr toolbar;
    application->AddToolbar(
        LispSampleApplication::appID,
        dsUIState_Document,
        L"LispSample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also add a new menu.

    m_CommandRegister.createUserCommand();
    m_CommandRegister.insert(menu, menu_position++);
    m_CommandRegister.insert(toolbar, toolbar_position++);

    m_CommandUnregister.createUserCommand();
    m_CommandUnregister.insert(menu, menu_position++);
    m_CommandUnregister.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
LispSample_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" LispSample_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalLispSample)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = LispSampleApplication::appID;
        globalLispSample = new LispSampleApplication(dsApp);
        globalLispSample->CreateUserInterfaceAndCommands();
    }
    return globalLispSample;
}

#ifdef DS_WIN
LispSample_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" LispSample_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalLispSample)
    {
        if (globalLispSample->getDsApp())
        {
            globalLispSample->getDsApp()->RemoveUserInterface(
                LispSampleApplication::appID);
        }
        delete globalLispSample;
        globalLispSample = 0;
    }
    return true;
}

#ifdef DS_WIN
LispSample_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" LispSample_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"A085E761-D046-4f6b-BFA2-02F0DDD1B10E" );
    return true;
}
