#include "dsCommandMessage_c.h"
#include "FunctionCalculate.h"

bool FunctionCalculate::ExecuteFunctionNotify()
{
    dsObjectPtrArray arguments;
    dsLispParameter_ptr pReturn;
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    m_function->GetArguments( &arguments );
    m_function->CreateReturnValue( &pReturn );

    if( !pReturn )
        return false;

    if( arguments.getSize() == 0 )
    {
        commandline->PrintLine(L"Incorrect number of parameters");
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    dsString sOperator;
    dsLispParameter_ptr pParam ( static_cast< dsLispParameter_c* >( arguments[ 0 ] ) );
    dsLispParameterType_e type;
    pParam->get_Type( &type );
    if( type == dsLispParameterType_String )
    {
        pParam->GetString( &sOperator );
    }

    double dResult = 0;
    if (sOperator.CompareNoCase(L"*") == 0)
    {
        dResult = 1;
    }

    unsigned int i, iSize = arguments.getSize();
    for( i = 1; i < iSize; i++ )
    {
        dsLispParameter_ptr pParam ( static_cast< dsLispParameter_c* >( arguments[ i ] ) );
        dsLispParameterType_e type;
        pParam->get_Type( &type );

        double dData = 0;
        if( type == dsLispParameterType_Integer )
        {
            long iData = 0;
            pParam->GetInteger( &iData );
            dData = iData;
        }
        else if( type == dsLispParameterType_Double )
        {
            pParam->GetDouble( &dData );
        }

        if (sOperator.CompareNoCase(L"+") == 0)
        {
            dResult += dData;
        }
        else if (sOperator.CompareNoCase(L"-") == 0)
        {
            dResult -= dData;
        }
        else if (sOperator.CompareNoCase(L"*") == 0)
        {
            dResult *= dData;
        }
    }

    //Create a Void return value
    dsLispParameter_ptr pDouble;
    m_function->CreateReturnValue( &pDouble );
    pDouble->SetToDouble(dResult);
    m_function->SetReturnValue( pDouble );

    return true;
}
