#include "dsCommandMessage_c.h"
#include "FunctionPaintRed.h"

bool FunctionPaintRed::ExecuteFunctionNotify()
{
    dsObjectPtrArray arguments;
    dsLispParameter_ptr pReturn;
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    m_function->GetArguments( &arguments );
    m_function->CreateReturnValue( &pReturn );

    if( !pReturn )
        return false;

    if( arguments.getSize() == 0 )
    {
        commandline->PrintLine(L"Incorrect number of parameters");
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    dsLispParameter_ptr pHandleParam ( static_cast< dsLispParameter_c* >( arguments[ 0 ] ) );

    dsLispParameterType_e type;
    pHandleParam->get_Type( &type );
    if( type != dsLispParameterType_Handle )
    {
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    dsString strHandle;
    pHandleParam->GetHandle( &strHandle );

    dsObjectType_e objType;
    dsObject* obj;
    dsDocument_ptr pDoc;
    application->GetActiveDocument(&pDoc);
    pDoc->GetObjectByHandle( strHandle, &objType, &obj );

    if( !obj )
    {
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    dsEntityHelper_ptr pHelper;
    application->GetEntityHelper( &pHelper );
    if( !pHelper )
    {
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    dsColor_ptr pColor;
    application->GetNamedColor( dsNamedColor_Red, &pColor );
    pHelper->SetColor( obj, pColor );
    pHelper->SetLineWeight(obj, dsLnWt_018);

    pReturn->SetToTrue();
    m_function->SetReturnValue( pReturn );

    return true;
}
