#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

PostEventApplication *globalPostEvent = 0;
const dsString PostEventApplication::appID = L"78353AED-3A00-4774-81E8-16A606CBC6C1";

void PostEventApplication::ReferenceOpenDocs()
{
    dsObjectPtrArray documents;
    application->GetDocuments(&documents);
    for (int doc = 0; doc < documents.getSize(); ++doc)
        m_documents.push_back(new DsAddinDocument((dsDocument_c*)documents[doc]));
}

#ifdef DS_WIN
PostEvent_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" PostEvent_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalPostEvent)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = PostEventApplication::appID;
        globalPostEvent = new PostEventApplication(dsApp);
        globalPostEvent->ReferenceOpenDocs();
    }
    return globalPostEvent;
}

#ifdef DS_WIN
PostEvent_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" PostEvent_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalPostEvent)
    {
        if (globalPostEvent->getDsApp())
        {
            globalPostEvent->getDsApp()->RemoveUserInterface(
                PostEventApplication::appID);
        }

        delete globalPostEvent;
        globalPostEvent = 0;
    }

    return true;
}

#ifdef DS_WIN
PostEvent_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" PostEvent_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"B9DC5AAC-D004-434E-BC1F-BCC52C676128" );
    return true;
}

ImplementApplicationFileNewNotifyHook(PostEventApplication)
ImplementApplicationFileOpenPostNotifyHook(PostEventApplication)
ImplementApplicationActiveDocumentChangedNotifyHook(PostEventApplication)

bool PostEventApplication::FileNewNotify(dsDocument_c* docIn) 
{
    m_documents.push_back(new DsAddinDocument(docIn));
    return true;
}

bool PostEventApplication::ActiveDocumentChangedNotify()
{
    m_documents.remove_if(destroyClosedDocument);
    return true; 
}

bool PostEventApplication::FileOpenPostNotify(dsDocument_c *docIn)
{
    m_documents.push_back(new DsAddinDocument(docIn));
    return true; 
}
