#include "dsCommandMessage_c.h"
#include "dsDocument_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsInterfacePtr.h"
#include "dsNote_c.h"
#include "dsPolyLine_c.h"

#include "miscellaneous.h"
#include "TextInserter.h"

bool TextInserter::insert()
{
    // Get the DraftSight command line interface.
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    // Get the active document to get the model to get the
    // sketch manager in order to insert the text.
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);

    // Insert the note ...
    dsNote_ptr note;
    sketchmanager->InsertNote(
        m_x1, m_y1, m_z1,
        m_x2, m_y2, m_z2,
        q2d(m_text.split("\n")),
        &note);
    note->put_Color(m_color);
    note->put_LineStyle(m_linestyle);
    note->put_LineWeight(m_lineweight);
    note->put_TextStyle(m_textstyle);

    // ... and its kind-of-bounding-box.
    dsPolyLine_ptr polyline;
    sketchmanager->InsertPolyline2D(
        makeArray<dsDoubleArray, double>(8,
        m_x1, m_y1,
        m_x2, m_y1,
        m_x2, m_y2,
        m_x1, m_y2),
        true,
        &polyline);
    polyline->put_Color(m_color);
    polyline->put_LineStyle(m_linestyle);
    polyline->put_LineWeight(m_lineweight);

    commandline->PrintLine(q2d(tr(
        "<p style=\"color:#99cc00;font-weight:bold\">"
        "\"%1\" inserted."
        "</p>")
        .arg(m_text)));

    return true;
}
