#include <QtCore/QDir>
#include <QtWidgets/QDialog>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QDialogButtonBox>

#include "../Options.h"
#include "../TextInserter.h"
#include "../ui/TextInsertionWidget.h"
#include "CommandDialog.h"

bool CommandDialog::ExecuteNotify()
{
    // Construct a little dialog containing the TextInsertionWidget,
    // an OK button, a Cancel button and a help button.
    QDialog dialog;
    TextInsertionWidget w(&dialog);
    QDialogButtonBox buttons(
        QDialogButtonBox::Ok | QDialogButtonBox::Cancel | QDialogButtonBox::Help,
        Qt::Horizontal,
        &dialog);
    QObject::connect(&buttons, SIGNAL(accepted()), &dialog, SLOT(accept()));
    QObject::connect(&buttons, SIGNAL(rejected()), &dialog, SLOT(reject()));
    QVBoxLayout *vbox = new QVBoxLayout;
    vbox->addWidget(&w);
    vbox->addWidget(&buttons);
    dialog.setLayout(vbox);
    dialog.resize(600, 400);

    // Leave, if the dialog was canceled.
    if (dialog.exec() != QDialog::Accepted)
        return false;

    // Insert the text with its selected properties.
    TextInserter inserter(
        application,
        w.text(),
        w.x1(), w.y1(), w.z1(),
        w.x2(), w.y2(), w.z2(),
        w.color(),
        w.linestyle(),
        w.lineweight(),
        w.textstyle());
    return inserter.insert();
}
