#include "stdafx.h"

#include "Options.h"
#include "dsAddinConnection.h"

PropertyWidgetsApplication *globalPropertyWidgets = 0;
const dsString PropertyWidgetsApplication::appID = L"F10FC7BD-FFED-4759-B583-12A1F1A9ABA8";

bool PropertyWidgetsApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandDialog.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    m_dsApp->AddMenu(
        PropertyWidgetsApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"PropertyWidgets",
        &menu);
    if (!menu)
        return false;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    m_dsApp->AddToolbar(
        PropertyWidgetsApplication::appID,
        dsUIState_Document,
        L"PropertyWidgets",
        &toolbar );
    if (!toolbar)
        return false;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also create a new menu.

    m_CommandDialog.createUserCommand();
    m_CommandDialog.insert(menu, menu_position++);
    m_CommandDialog.insert(toolbar, toolbar_position++);

    return true;
}

#ifdef DS_WIN
PropertyWidgets_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" PropertyWidgets_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalPropertyWidgets)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = PropertyWidgetsApplication::appID;
        globalPropertyWidgets = new PropertyWidgetsApplication(dsApp);
        globalPropertyWidgets->CreateUserInterfaceAndCommands();
        return true;
    }
    return false;
}

#ifdef DS_WIN
PropertyWidgets_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" PropertyWidgets_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalPropertyWidgets)
    {
        if (globalPropertyWidgets->getDsApp())
        {
            globalPropertyWidgets->getDsApp()->RemoveUserInterface(
                PropertyWidgetsApplication::appID);
        }
        delete globalPropertyWidgets;
        globalPropertyWidgets = 0;
    }

    return true;
}

#ifdef DS_WIN
PropertyWidgets_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" PropertyWidgets_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = L"B3A8D708-5C18-4b4a-94E7-01AED3078946";
    return true;
}
