#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: PropertyWidgets

Sample Description:
    This sample shows the creation and usage of combo boxes for four common
    properties: color, line type, line width and text style. This is
    illustrated by drawing a text and its bounding box according to the
    specified properties.

Usage:
    This example has one command, which can be invoked using either the
    command line or by using the menu "PropertyWidgets".
        
    _PWDIALOG "Open text inserter"
        Opens a modal dialog you can use to insert the text.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Graphical User Interface:
        The class TextInsertionWidget (.h, .cpp, .ui) is the GUI of this
        add-in. It appears as a local variable in CommandDialog::
        ExecuteNotify(), embedded in a modal dialog.

    Functionality:
        Though the actual insertion job is done by the class TextInserter,
        our attention is attracted to the four following combo boxes:
            - dsColorCombobox
            - dsLinestyleCombobox
            - dsLineweightCombobox
            - dsTextstyleCombobox
        These short classes are the property widgets, and thus the topic
        which this sample is about. They show how you can use Qt to
        assemble widgets (or controls) for dsAPI add-ins. Please have a
        thorough look there.

    Command classes:
        _PWDIALOG (class CommandDialog) derives from CommandBase. This base
        class provides an interface for both, registering a command to be
        used from the command line via CommandBase::registerCommand() as
        well as putting a command into a menu item via CommandBase::
        createUserCommand(), so done in PropertyWidgetsApplication::
        CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.
        
        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsApplication_c::GetNamedColor()
        dsApplication_c::CreateColorPicker()
        dsColorPicker_c::GetColor()
        dsLineStyleManager_c::GetActiveLineStyle()
        dsLineStyleManager_c::GetLineStyles()
        dsTextStyleManager_c::GetActiveTextStyle()
        dsTextStyleManager_c::GetTextStyles()
*/

#include <QObject>
#include "dsApplication_c.h"
#include "dsInterfacePtr.h"

#include "PropertyWidgets_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of PropertyWidgetsApplication.
// 3 - Go to bool PropertyWidgetsApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandDialog.h"        

class PropertyWidgets_EXPORT PropertyWidgetsApplication : public QObject
{
    Q_OBJECT
public:
    PropertyWidgetsApplication(dsApplication_c *dsApp)
        : QObject(0)
        , m_dsApp(dsApp)
    {}

    dsApplication_c* getDsApp() { return m_dsApp; }  

    // Registers commands to the command line,
    // to the menu and to a toolbar.
    bool CreateUserInterfaceAndCommands();

    static const dsString appID;

private:
    dsApplication_ptr m_dsApp;
    CommandDialog m_CommandDialog;
};

#endif // DS_ADDIN_CONNECTION_H
