#include "../miscellaneous.h"
#include "../Options.h"
#include "TextInsertionWidget.h"

TextInsertionWidget::TextInsertionWidget(QWidget *parent /*= 0*/)
: QWidget(parent)
, application(Options::instance().application)
{
    ui.setupUi(this);
    on_ed_p1_textChanged(ui.ed_p1->text());
    on_ed_p2_textChanged(ui.ed_p2->text());
}

void TextInsertionWidget::on_ed_p1_textChanged( const QString &text )
{
    m_x1 = m_y1 = m_z1 = 0;
    QStringList l = text.split(",");
    if (l.size() > 0)
        m_x1 = l[0].toDouble();
    if (l.size() > 1)
        m_y1 = l[1].toDouble();
    if (l.size() > 2)
        m_z1 = l[2].toDouble();
}

void TextInsertionWidget::on_ed_p2_textChanged( const QString &text )
{
    m_x2 = m_y2 = m_z2 = 0;
    QStringList l = text.split(",");
    if (l.size() > 0)
        m_x2 = l[0].toDouble();
    if (l.size() > 1)
        m_y2 = l[1].toDouble();
    if (l.size() > 2)
        m_z2 = l[2].toDouble();
}
