#include "dsColorPicker_c.h"

#include "Options.h"
#include "dsColorCombobox.h"

dsColorCombobox::dsColorCombobox(QWidget *parent /*= 0*/) : QComboBox(parent)
{
    addItem(tr("ByBlock"));
    addItem(tr("ByLayer"));
    addItem(tr("Red"));
    addItem(tr("Yellow"));
    addItem(tr("Green"));
    addItem(tr("Cyan"));
    addItem(tr("Blue"));
    addItem(tr("Magenta"));
    addItem(tr("White"));
    addItem(tr("Specify Color..."));

    setCurrentIndex(1);
    // Signal activated() will not be emitted programmatically.
    on_activated(currentIndex());
    connect(this, SIGNAL(activated(int)), SLOT(on_activated(int)));
}

void dsColorCombobox::on_activated(int index)
{
    switch (index)
    {
    case 0:
        Options::instance().application->GetNamedColor(dsNamedColor_ByBlock, &m_color);
        break;
    case 1:
        Options::instance().application->GetNamedColor(dsNamedColor_ByLayer, &m_color);
        break;
    case 2:
        Options::instance().application->GetNamedColor(dsNamedColor_Red, &m_color);
        break;
    case 3:
        Options::instance().application->GetNamedColor(dsNamedColor_Yellow, &m_color);
        break;
    case 4:
        Options::instance().application->GetNamedColor(dsNamedColor_Green, &m_color);
        break;
    case 5:
        Options::instance().application->GetNamedColor(dsNamedColor_Cyan, &m_color);
        break;
    case 6:
        Options::instance().application->GetNamedColor(dsNamedColor_Blue, &m_color);
        break;
    case 7:
        Options::instance().application->GetNamedColor(dsNamedColor_Magenta, &m_color);
        break;
    case 8:
        Options::instance().application->GetNamedColor(dsNamedColor_White, &m_color);
        break;
    case 9:
        {
            dsInterfacePtr<dsColorPicker_c> picker;
            dsExecuteDlgResult_e result;
            Options::instance().application->CreateColorPicker(false, true, &picker);
            picker->SetColor(m_color);
            picker->Execute(&result);
            if (result == dsExecuteDlgResult_Accepted)
                picker->GetColor(&m_color);
        }
        break;
    default: break;
    }
}
