#ifndef DSLINESTYLECOMBOBOX_H
#define DSLINESTYLECOMBOBOX_H

#include <QtWidgets/QComboBox>
#include "miscellaneous.h"

// This class provides a combo box for line styles.
class dsLinestyleCombobox : public QComboBox
{
    Q_OBJECT
public:
    dsLinestyleCombobox(QWidget *parent = 0) : QComboBox(parent) { populate(); }
    dsString getLinestyle() const { return m_linestyle; }

public slots:
    // Fills the combo box with all available line styles and
    // sets the current index to the active line style.
    void populate();

protected slots:
    void on_activated(int index);

protected:
    dsString m_linestyle;
};

#endif // DSLINESTYLECOMBOBOX_H