#include "dsLineweightCombobox.h"

dsLineweightCombobox::dsLineweightCombobox(QWidget *parent /*= 0*/)
: QComboBox(parent)
{
    addItem(tr("ByBlock"));
    addItem(tr("ByLayer"));
    addItem(tr("Default"));
    addItem(tr("0.00 mm"));
    addItem(tr("0.05 mm"));
    addItem(tr("0.09 mm"));
    addItem(tr("0.13 mm"));
    addItem(tr("0.15 mm"));
    addItem(tr("0.18 mm"));
    addItem(tr("0.20 mm"));
    addItem(tr("0.25 mm"));
    addItem(tr("0.30 mm"));
    addItem(tr("0.35 mm"));
    addItem(tr("0.40 mm"));
    addItem(tr("0.50 mm"));
    addItem(tr("0.53 mm"));
    addItem(tr("0.60 mm"));
    addItem(tr("0.70 mm"));
    addItem(tr("0.80 mm"));
    addItem(tr("0.90 mm"));
    addItem(tr("1.00 mm"));
    addItem(tr("1.06 mm"));
    addItem(tr("1.20 mm"));
    addItem(tr("1.40 mm"));
    addItem(tr("1.58 mm"));
    addItem(tr("2.00 mm"));
    addItem(tr("2.11 mm"));
    setCurrentIndex(1);
}

dsLineWeight_e dsLineweightCombobox::getLineweight() const
{
    switch (currentIndex())
    {
    case 0: return dsLnWt_ByBlock;
    case 1: return dsLnWt_ByLayer;
    case 2: return dsLnWt_ByLwDefault;
    case 3: return dsLnWt_000;
    case 4: return dsLnWt_005;
    case 5: return dsLnWt_009;
    case 6: return dsLnWt_013;
    case 7: return dsLnWt_015;
    case 8: return dsLnWt_018;
    case 9: return dsLnWt_020;
    case 10: return dsLnWt_025;
    case 11: return dsLnWt_030;
    case 12: return dsLnWt_035;
    case 13: return dsLnWt_040;
    case 14: return dsLnWt_050;
    case 15: return dsLnWt_053;
    case 16: return dsLnWt_060;
    case 17: return dsLnWt_070;
    case 18: return dsLnWt_080;
    case 19: return dsLnWt_090;
    case 20: return dsLnWt_100;
    case 21: return dsLnWt_106;
    case 22: return dsLnWt_120;
    case 23: return dsLnWt_140;
    case 24: return dsLnWt_158;
    case 25: return dsLnWt_200;
    case 26: return dsLnWt_211;
    default: return dsLnWt_ByLwDefault;
    }
}
