#ifndef DSTEXTSTYLECOMBOBOX_H
#define DSTEXTSTYLECOMBOBOX_H

#include <QtWidgets/QComboBox>
#include "miscellaneous.h"

// This class provides a combo box for text styles.
class dsTextstyleCombobox : public QComboBox
{
    Q_OBJECT
public:
    dsTextstyleCombobox(QWidget *parent = 0) : QComboBox(parent) { populate(); }
    dsString getTextstyle() const { return q2d(currentText()); }

public slots:
    // Fills the combo box with all available text styles and
    // sets the current index to the active text style.
    void populate();
};

#endif // DSTEXTSTYLECOMBOBOX_H