#ifndef OPTIONS_H
#define OPTIONS_H

//#include <QString>
#include "dsString.h"
#include "dsApplication_c.h"

struct OptionsRecord
{
    dsApplication_c *application;
    dsString ApiUuid;

    OptionsRecord(): application(0) {}
};

// This singleton class represents the settings for this add-in to operate.
// It is accessible throughout the add-in. You can access the singleton
// using the static method instance().
class Options : public OptionsRecord
{
public:
    // Get access to the singleton object.
    static Options& instance() {
        static Options o;
        return o;
    }

    // Sets the options to some default settings.
    void setDefault();

protected:
    // The options are singleton.
    Options() { setDefault(); }
};

#endif // OPTIONS_H
