#pragma once

#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

#include "dsTracker_c.h"
#include "dsBlockDefinition_c.h"
#include "dsBlockInstance_c.h"

class CommandSerialResistor : public CommandBase
{
public:
    CommandSerialResistor();
    virtual ~CommandSerialResistor();
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_SERIALRESISTOR"; }
    const dsString localName() const { return L"SERIALRESISTOR"; }
    const dsString Description() const { return L"Serial the circuit"; }
    const dsString ItemName() const { return L"SerialResistor"; }

    bool ExecuteNotify();
    void getStartAndEndPts( dsDocument_c *doc, dsObject* obj, dsMathPoint_c *firstPt, dsMathPoint_c*secPt );
    void createSerialization( dsSketchManager_ptr sketch_manager, dsBlockInstance_c* blkInst, dsBlockInstance_c* blkInstNext, dsMathPoint_c *stPt, 
        dsMathPoint_c *endPt, double angle, bool TemporaryCreation = false );
    void createResistor( dsSketchManager_ptr sketch_manager, dsBlockInstance_c* blkInst, dsBlockInstance_c* blkInstNext, dsMathUtility_c* pMathUtil, dsMathPoint_c *firstPt, 
        dsMathPoint_c*secPt, int iVoltage, int iCurrent, bool TemporaryCreation = false );
    int getCurrent( dsObject* obj );
    void DoSerialize( dsDocument_c *doc, dsObjectPtrArray objects, bool TemporaryCreation = false );
    dsMathPoint_c* addPointToVector(dsMathPoint_c* pPoint, dsMathVector_c* pMathVector);
    dsMathPoint_c* createPoint(double x, double y, double z);

    DeclareTrackerUpdateNotifyHook
    bool UpdateNotify(dsMathPoint_c *CursorPosition);

private:
    dsTracker_ptr m_Tracker;
    dsSimpleNote_ptr dsSimpleNote;
    //dsObjectPtrArray m_EntityArray;
};