﻿#include "miscellaneous.h"
#include <sstream>
#include <stdio.h>
#include "dsCommandMessage_c.h"
#include "dsAddinConnection.h"

int d2i( const dsString &s )
{
    std::wstring w((wchar_t*)s);
    std::ostringstream o;
    const std::ctype<char> &facet = std::use_facet< std::ctype<char> >(o.getloc());
    for (size_t i = 0; i < w.size(); ++i) 
        o << facet.narrow(w[i]);
    return std::atoi(o.str().c_str());
}

dsString getResistance( int i )
{
    std::wostringstream s;
    s << i;
    s << L"\u03a9";
    return dsString( s.str().c_str() );
}

dsAttributeDefinition_c* get_attribute_definition( 
    dsAttributeInstance_c *attribute_instance, dsObjectPtrArray &attribute_definitions )
{
    dsString tag_instance;
    attribute_instance->GetName(&tag_instance);

    dsString tag_definition;
    for (unsigned int i = 0; i < attribute_definitions.getSize(); ++i)
    {
        dsAttributeDefinition_c *attribute_definition =
            (dsAttributeDefinition_c*)attribute_definitions[i];
        attribute_definition->get_Name(&tag_definition);

        if (tag_instance != tag_definition)
            continue;
        return attribute_definition;
    }
    return 0;
}

dsMathPoint_c* getMidPoint( dsMathUtility_c* pMathUtil, dsMathPoint_c* pt1, dsMathPoint_c* pt2 )
{
    dsMathPoint_c* pPoint = NULL;
    double dx1 = 0 , dy1 = 0 , dz1 = 0;
    pt1->GetPosition( &dx1, &dy1, &dz1 );

    TBPoint3D ptFirst(0, 0, 0);
    ptFirst.setX( dx1 );
    ptFirst.setY( dy1 );
    ptFirst.setZ( dz1 );
    double dx2 = 0 , dy2 = 0 , dz2 = 0;
    pt2->GetPosition( &dx2, &dy2, &dz2 );
    TBPoint3D ptSec(0,0,0);
    ptSec.setX( dx2 );
    ptSec.setY( dy2 );
    ptSec.setZ( dz2 );

    TBPoint3D vecPtFirstToPtSec = ptSec - ptFirst;
    dsMathVector_c* dsVecMaxToMinExt = createVector( pMathUtil, vecPtFirstToPtSec.x(), vecPtFirstToPtSec.y(), vecPtFirstToPtSec.z() );
    dsVecMaxToMinExt->ScaleVector( .5 );
    pPoint = addPointToVector(pMathUtil, pt1, dsVecMaxToMinExt);
    return pPoint;
}

dsMathVector_c* createVector(dsMathUtility_c* pMathUtil, double x, double y, double z)
{
    dsMathVector_c *pVector = 0;
    pMathUtil->CreateVector(x, y, z, &pVector);
    return pVector;
}

dsMathPoint_c* addPointToVector(dsMathUtility_c* pMathUtil, dsMathPoint_c* pPoint, dsMathVector_c* pMathVector)
{
    double vX, vY, vZ;
    pMathVector->GetCoordinates(&vX, &vY, &vZ);
    double pX, pY, pZ;
    pPoint->GetPosition(&pX, &pY, &pZ);
    return createPoint(pMathUtil, pX + vX, pY + vY, pZ + vZ);
}

dsMathPoint_c* createPoint(dsMathUtility_c* pMathUtil, double x, double y, double z)
{
    dsMathPoint_c* pPoint = 0;
    pMathUtil->CreatePoint(x, y, z, &pPoint);
    return pPoint;
}