#include "dsCommandMessage_c.h"
#include "dsDocument_c.h"
#include "dsDictionary_c.h"
#include "dsByteArray.h"
#include "dsXRecord_c.h"
#include "CommandDemo.h"
#include <sstream>

bool CommandDemo::ExecuteNotify()
{
    //Get commandline
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    //Get active document
    dsDocument_c* document;
    application->GetActiveDocument(&document);
    if (!document)
        return false;

    //Get Model
    dsModel_ptr model;
    document->GetModel(&model);
    if (!model)
        return false;

    //Get Sketch Manager
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);
    if (!sketchmanager)
        return false;

    //Construct Circle
    dsCircle_ptr circle;
    sketchmanager->InsertCircle(5, 5, 0, 10, &circle);

    //Get drawing's root dictionary
    dsDictionary_c *root_dictionary;
    document->GetNamedObjectsDictionary(&root_dictionary);

    // Get an existing dictionary.
    // (e.g. each drawing has a table-style dictionary)
    bool hasEntry;
    root_dictionary->HasEntry(L"ACAD_TABLESTYLE", &hasEntry);

    if (hasEntry)
    {
        dsObjectType_e entityType;
        dsObject *entity;
        root_dictionary->GetEntry(L"ACAD_TABLESTYLE", &entityType, &entity);

        //Dictionary entries can be of arbitrary entity types.
        //In this case, the arbitrary entity type should be a dictionary.
        if (entityType == dsDictionaryType)
        {
            dsDictionary_c *dict = (dsDictionary_c*)entity;

            //Table-style dictionary should contain an active style
            dsTableStyleManager_ptr dsTblStyleMgr;
            document->GetTableStyleManager(&dsTblStyleMgr);
            dsTableStyle_ptr dsActiveTblStyle;
            dsTblStyleMgr->GetActiveTableStyle(&dsActiveTblStyle);

            dsString activeTblStyleEntryName;
            dict->GetNameOf(dsActiveTblStyle, &activeTblStyleEntryName);

			std::wostringstream prompt;
			prompt << L"Active table-style entry in existing main dictionary: "
				   << (wchar_t*)activeTblStyleEntryName;
			commandline->PrintLine( prompt.str().c_str() );
        }
    }

    //Create a dictionary in root dictionary
    dsDictionary_c *dsOurDict;
    root_dictionary->CreateDictionary(L"Our_Dict", &dsOurDict);

    //New dictionary is entry in root dictionary 
    //Check if dictionary has new entry
    bool hasOurDict;
    root_dictionary->HasEntry(L"Our_Dict", &hasOurDict);
    if (hasOurDict)
    {
		commandline->PrintLine( L"\"Our_Dict\" dictionary added in main Dictionary." );
    }

    //Add XRecord entry
    dsXRecord_c *dsOurXRecord;
    dsOurDict->CreateXRecord(L"Our_XRecord", &dsOurXRecord );

    //Check if dictionary has new entry
    bool hasOurXRecord;
    dsOurDict->HasEntry(L"Our_XRecord", &hasOurXRecord);
    if (hasOurXRecord)
    {
        commandline->PrintLine(L"\"Our_XRecord\" XRecord added in \"Our_Dict\" dictionary.");
    }

    //XRecords can contain arbitrary data
    long dataCount;
    dsOurXRecord->GetDataCount(&dataCount);

    //Add double data
    dsOurXRecord->InsertDoubleData(dataCount, 20, 1.42);
    dsOurXRecord->GetDataCount(&dataCount);

    //Add string data
    dsOurXRecord->InsertStringData(dataCount, 3, L"XRecordstring data");

    dsLongArray dsOurDictEntityTypes;
    dsObjectPtrArray OurDictEntries;
    dsOurDict->GetEntries(&dsOurDictEntityTypes, &OurDictEntries);
    for (int index = 0; index < dsOurDictEntityTypes.getSize(); ++index)
    {
        if ((dsObjectType_e)dsOurDictEntityTypes[index] == dsXRecordType)
        {
            dsXRecord_c *xRecord = (dsXRecord_c*)OurDictEntries[index];
            if (!xRecord)
                continue;

            long dataCount;
            xRecord->GetDataCount(&dataCount);

            for (int i = 0; i < dataCount; ++i)
            {
                dsCustomDataType_e type; 
                xRecord->GetDataType(i, &type);
                if(type == dsCustomDataType_String)
                {
                    dsString data;
                    xRecord->GetStringData(i, &data);
					std::wostringstream prompt;
					prompt << L"String XData of \"Our_XRecord\": "
						   << (wchar_t*)data;
					commandline->PrintLine( prompt.str().c_str() );
                }
                else if (type == dsCustomDataType_Double)
                {
                    double doubleData;
                    xRecord->GetDoubleData(i, &doubleData);
					std::wostringstream prompt;
					prompt << L"Double XData of \"Our_XRecord\": "
						   << doubleData;
					commandline->PrintLine( prompt.str().c_str() );
                }
            }
        }
    }

    //Each entity can have its own extension dictionary
    //Create extension dictionary for Circle entity
    dsDictionary_c *extDict;
    circle->CreateExtensionDictionary(&extDict);

    //Add XRecords to Circle's extension dictionary
    dsXRecord_c *dsXRecord1;
    extDict->CreateXRecord(L"XRecord1", &dsXRecord1);

    commandline->PrintLine(L"XRecord1 of Circle's extension dictionary Added.");

    dsXRecord1->InsertStringData(0, 1, L"part number");
    dsXRecord1->InsertInteger32Data(1, 90, 1);

    dsXRecord_c *dsXRecord2;
    extDict->CreateXRecord(L"XRecord2", &dsXRecord2);

    commandline->PrintLine(L"XRecord2 of Circle's extension dictionary added.");

    dsXRecord2->InsertStringData(0, 1, L"Description");
    dsXRecord2->InsertStringData(1, 3, L"Circle");

    //Read entries of Circle's extension dictionary
    dsLongArray dsEntityTypes;
    dsObjectPtrArray entries;

    extDict->GetEntries(&dsEntityTypes, &entries);

    for (int index = 0; index < dsEntityTypes.getSize(); ++index)
    {
        if((dsObjectType_e)dsEntityTypes[index] == dsXRecordType)
        {
            dsXRecord_c *xRecord = 0;
            xRecord = (dsXRecord_c *)entries[index];

            if(xRecord == 0)
            {
                continue;
            }

            long dataCount;
            xRecord->GetDataCount(&dataCount);

            for(int i = 0; i < dataCount; ++i)
            {
                dsCustomDataType_e type; 
                xRecord->GetDataType(i, &type);
                if(type == dsCustomDataType_String)
                {
                    dsString data;
                    xRecord->GetStringData(i, &data);
					std::wostringstream prompt;
					prompt << L"String XData of Circle's extension dictionary: "
						   << (wchar_t*)data;
					commandline->PrintLine( prompt.str().c_str() );
                }
                else if (type == dsCustomDataType_Integer32)
                {
                    long intData;
                    xRecord->GetInteger32Data(i, &intData);
					std::wostringstream prompt;
					prompt << L"String XData of Circle's extension dictionary: "
						   << intData;
					commandline->PrintLine( prompt.str().c_str() );
                }
            }
        }
    }

    //Remove the XRecords in the Circle's extension dictionary
    extDict->RemoveEntry(L"XRecord1");
    extDict->RemoveEntry(L"XRecord2");
    commandline->PrintLine(L"XRecord1 and XRecord2 of Circle's extension dictionary removed.");

    //Release and erase the Circle's extension dictionary
    bool removed;
    circle->ReleaseExtensionDictionary(&removed);
    if (removed)
        commandline->PrintLine(L"Circle's extension dictionary released and erased.");

    return true; 
}
