#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: DrawCircleCommand

Sample Description:
    This sample demonstrates how to create a simple command creating a
    circle using the dsAPI math utility classes.

Usage:
    There is one command to be called from the command line:

    _DRAWCIRCLE
        This command prompts the user to enter a center point and a point
        on the circle, calculating a drawing the circle from that
        information.

Overview:
    Functionality:
        We want to draw your attention to _DRAWCIRCLE's command body
        CommandDrawCircle::ExecuteNotify(), where everything interesting
        happens.

    Command classes:
        _DRAWCIRCLE (class CommandDrawCircle) derives from CommandBase.
        This base class provides an interface for both, registering a
        command to be used from the command line via CommandBase::
        registerCommand() as well as putting a command into a menu item via
        CommandBase::createUserCommand(), so done in
        ContextMenuApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsCommandMessage_c::PromptForPoint()
        dsCommandMessage_c::PromptForPoint2()
        dsMathPlane_c::CreateXYPlane()
        dsMathPlane_c::CreatePoint()
        dsMathPoint_c::ConvertToVector()
        dsSketchManager_c::InsertCircle()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "DrawCircleCommand_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of DrawCircleCommandApplication.
// 3 - Go to bool DrawCircleCommandApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandDrawCircle.h"

class DrawCircleCommand_EXPORT DrawCircleCommandApplication
{
public:
    DrawCircleCommandApplication(dsApplication_c *dsApp)
        : application(dsApp) {}

    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandDrawCircle m_CommandDrawCircle;
};

#endif // DS_ADDIN_CONNECTION_H
