#include "DrawingRootpathDialog.h"
#include "Converter.h"
#include "CommandDrawingToImage.h"

CommandDrawingToImage::CommandDrawingToImage(
    dsApplication_c *application,
    const dsString &groupName)
: application(application)
, m_command(0)
, m_user_command(0)
, m_group_name(groupName)
, m_global_name(L"_DRAWINGTOIMAGE")
, m_local_name(q2d(tr("DRAWINGTOIMAGE")))
, m_description(q2d(tr("Convert drawings to image files")))
, m_item_name(q2d(tr("Drawing to image")))
{
    dsCreateCommandError_e error;
    application->CreateCommand2(
        m_group_name,
        m_global_name,
        m_local_name,
        &error,
        &m_command);
    if (error == dsCreateCommand_Succeeded && m_command)
        RegisterCommandExecuteNotifyHook(m_command);
}

CommandDrawingToImage::~CommandDrawingToImage()
{
    if (m_command)
        UnRegisterCommandExecuteNotifyHook(m_command);
}

bool CommandDrawingToImage::ExecuteNotify()
{
    DrawingRootpathDialog dialog;
    if (dialog.exec() != QDialog::Accepted)
        return false;
    Converter converter(application);
    converter.convert(dialog.getDrawings());
    return true;
}

dsCreateCommandError_e CommandDrawingToImage::createUserCommand()
{
    std::wstring user_command_name(L"^C^C");
    user_command_name += m_global_name;

    dsCreateCommandError_e error;
    m_user_command_id = L"";
    application->CreateUserCommand(
        m_group_name,
        m_global_name,
        user_command_name.c_str(),
        m_description,
        L"",
        L"", 
        dsUIState_Document,
        &error,
        &m_user_command);
    m_user_command->GetID(&m_user_command_id);
    return error;
}

dsMenuItem_c* CommandDrawingToImage::insert( dsMenuItem_c *menu, const int &position )
{
    dsMenuItem_c *item = 0;
    menu->InsertMenuItem(
        m_group_name,
        dsMenuItemType_UserCommand,
        position,
        m_item_name,
        m_user_command_id,
        &item);
    return item;
}

dsToolbarItem_c* CommandDrawingToImage::insert( dsToolbar_c *toolbar, const int &position )
{
    dsToolbarItem_c *item = 0;
    toolbar->InsertToolbarItem(
        m_group_name,
        dsToolBarItemType_UserCommand,
        position,
        m_item_name,
        m_user_command_id,
        &item);
    return item;
}

ImplementCommandExecuteNotifyHook(CommandDrawingToImage)
