#ifndef COMMANDDRAWINGTOIMAGE_H
#define COMMANDDRAWINGTOIMAGE_H

#include <QCoreApplication>

#include "dsInterfacePtr.h"
#include "dsCommand_c.h"
#include "dsUserCommand_c.h"
#include "dsApplication_c.h"
#include "dsMenuItem_c.h"
#include "dsToolbarItem_c.h"
#include "dsToolbar_c.h"

#include "miscellaneous.h"

// This class registers itself on construction so it can be called from
// the command line and it adds itself to a menu and to a toolbar.
class CommandDrawingToImage
{
    Q_DECLARE_TR_FUNCTIONS(CommandDrawingToImage)
public:
    CommandDrawingToImage(dsApplication_c *application, const dsString &groupName);
    ~CommandDrawingToImage();
    bool ExecuteNotify();

    // Creates a 'user' command, i.e. a UI command, that enables the
    // user to invoke the command from a menu or a toolbar.
    // NOTE: The command needs to be registered first,
    //       so invoke registerCommand() beforehand.
    dsCreateCommandError_e createUserCommand();

    // Inserts the command into the given menu at the given position.
    // NOTE: The command needs to be registered first, so invoke both
    //       registerCommand() and createUserCommand() beforehand.
    dsMenuItem_c* insert(dsMenuItem_c *menu, const int &position);

    // Inserts the command into the given toolbar at the given position.
    // NOTE: The command needs to be registered first, so invoke both
    //       registerCommand() and createUserCommand() beforehand.
    dsToolbarItem_c* insert(dsToolbar_c *toolbar, const int &position);

    DeclareCommandExecuteNotifyHook

private:
    dsApplication_c *application;
    dsCommand_ptr m_command;
    dsUserCommand_ptr m_user_command;
    dsString m_group_name;
    dsString m_global_name;
    dsString m_local_name;
    dsString m_description;
    dsString m_item_name;
    dsString m_user_command_id;
};

#endif // COMMANDDRAWINGTOIMAGE_H
