#include <QStyle>
#include "PathEdit.h"

PathEdit::PathEdit( QWidget *parent /*= 0*/)
: QLineEdit(parent)
, bt_select(this)
, m_dialog_prompt(tr("Choose path"))
, m_filemode(QFileDialog::AnyFile)
{
    connect(&bt_select, SIGNAL(clicked()), SLOT(on_bt_select_clicked()));

    bt_select.setCursor(Qt::ArrowCursor);
    bt_select.setToolButtonStyle(Qt::ToolButtonTextOnly);
    bt_select.setText("...");
    bt_select.setStyleSheet("QToolButton { border: none; padding: 0px; }");
    int w = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);
    setStyleSheet(QString("QLineEdit { padding-right: %1px; } ")
        .arg(bt_select.sizeHint().width() + w + 1));
    QSize s = minimumSizeHint();
    setMinimumSize(
        qMax(s.width(), bt_select.sizeHint().height() + w * 2 + 2),
        qMax(s.height(), bt_select.sizeHint().height() + w * 2 + 2));
    bt_select.show();
    resizeEvent(0);
}

void PathEdit::on_bt_select_clicked()
{
    QFileDialog dialog(0,m_dialog_prompt,text());
    dialog.setFileMode(m_filemode);
    if (dialog.exec())
        setText(dialog.selectedFiles().join(","));
}

void PathEdit::resizeEvent( QResizeEvent* )
{
    QSize s = bt_select.sizeHint();
    int w = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);
    bt_select.move(
        rect().right() - w - s.width(),
        (rect().bottom() + 1 - s.height())/2);
}

void PathEdit::setVisible( bool visible )
{
    QLineEdit::setVisible(visible);
    bt_select.setVisible(visible);
}
