#include "stdafx.h"
#include "dsAddinConnection.h"

DrawingToImageApplication *globalDrawingToImage = 0;
const dsString DrawingToImageApplication::m_AddinGUID = L"B70E6670-D287-4E1F-80BD-455508828264";

DrawingToImageApplication::DrawingToImageApplication(dsApplication_c *dsApp) 
: application(dsApp)
, m_CommandDrawingToImage(dsApp, m_AddinGUID)
{
}

void DrawingToImageApplication::CreateUserInterfaceAndCommands()
{
    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        DrawingToImageApplication::m_AddinGUID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"DrawingToImage",
        &menu);
    if (!menu)
        return;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        DrawingToImageApplication::m_AddinGUID,
        dsUIState_Document,
        L"DrawingToImage",
        &toolbar );
    if (!toolbar)
        return;

    m_CommandDrawingToImage.createUserCommand();
    m_CommandDrawingToImage.insert(menu, 1);
    m_CommandDrawingToImage.insert(toolbar, 1);
}

#ifdef DS_WIN
DrawingToImage_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" DrawingToImage_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalDrawingToImage)
    {
        globalDrawingToImage = new DrawingToImageApplication(dsApp);
        globalDrawingToImage->CreateUserInterfaceAndCommands();
        return true;
    }
    return false;
}

#ifdef DS_WIN
DrawingToImage_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" DrawingToImage_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalDrawingToImage)
    {
        if (globalDrawingToImage->getDsApp())
        {
            globalDrawingToImage->getDsApp()->RemoveUserInterface(
                DrawingToImageApplication::m_AddinGUID);
        }
        delete globalDrawingToImage;
        globalDrawingToImage = 0;
    }
    return true;
}

#ifdef DS_WIN
DrawingToImage_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" DrawingToImage_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = L"A260970C-2CEB-4e83-ACAF-876E958A33AE";
    return true;
}
