#include <QPixmap>
#include "EntityPreviewDialog.h"

EntityPreviewDialog::EntityPreviewDialog(
    QImage *imageAllGeometry,
    QImage *imageCurrentView,
    QImage *imageNamedView,
    QImage *imageSpecifyWindow,
    QWidget *parent /*= 0*/)
: imageAllGeometry(imageAllGeometry)
, imageCurrentView(imageCurrentView)
, imageNamedView(imageNamedView)
, imageSpecifyWindow(imageSpecifyWindow)
, QDialog(parent)
{
    ui.setupUi(this);
    ui.view->setScene(&m_scene);
}

void EntityPreviewDialog::on_bt_all_geometry_clicked()
{
    m_scene.addPixmap(QPixmap::fromImage(*imageAllGeometry));
}

void EntityPreviewDialog::on_bt_current_view_clicked()
{
    m_scene.addPixmap(QPixmap::fromImage(*imageCurrentView));
}

void EntityPreviewDialog::on_bt_named_view_clicked()
{
    m_scene.addPixmap(QPixmap::fromImage(*imageNamedView));
}

void EntityPreviewDialog::on_bt_specify_window_clicked()
{
    m_scene.addPixmap(QPixmap::fromImage(*imageSpecifyWindow));
}
