#ifndef OPTIONS_H
#define OPTIONS_H

#include "dsString.h"
#include "dsApplication_c.h"

struct OptionsRecord
{
    dsApplication_c *application;
    dsString ApiUuid;

    OptionsRecord(): application(0) {}
};

// This singleton class represents the settings for this add-in to operate.
// It is accessible throughout the add-in. You can access the singleton
// using the static method instance().
class Options : public OptionsRecord
{
public:
    // Get access to the singleton object.
    static Options& instance() {
        static Options o;
        return o;
    }

protected:
    // The options are singleton.
    Options(){}
};

#endif // OPTIONS_H
