#include "stdafx.h"
#include <QMessageBox>
#include "dsAddinDocument.h"

ImplementDocumentDestroyNotifyHook(DsAddinDocument)
ImplementDocumentFileSavePreNotifyHook(DsAddinDocument)
ImplementDocumentFileSavePostNotifyHook(DsAddinDocument)
ImplementDocumentModifyNotifyHook(DsAddinDocument)
ImplementSelectionManagerSelectionChangedNotifyHook(DsAddinDocument)

bool DsAddinDocument::DestroyNotify()
{
    m_isAlive = false;
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsDocument hook: DsAddinDocument::DestroyNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}

bool DsAddinDocument::FileSavePreNotify(
    dsString FileName, dsDocumentSaveAsOption_e SaveOption)
{
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsDocument hook: DsAddinDocument::FileSavePreNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}

bool DsAddinDocument::FileSavePostNotify()
{
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsDocument hook: DsAddinDocument::FileSavePostNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}

bool DsAddinDocument::ModifyNotify()
{
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsDocument hook: DsAddinDocument::ModifyNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}

bool DsAddinDocument::SelectionChangedNotify()
{
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsDocument hook: DsAddinDocument::SelectionChangedNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}

bool destroyClosedDocument(DsAddinDocument* dsDoc)
{
    if (!dsDoc->isAlive())
    {
        delete dsDoc;
        dsDoc = 0;
        return true;
    }
    return false;
}
