#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: TrackerDemo

Sample Description:
    This sample demonstrates the usage of trackers and temporary entities
    in dsAPI. Following events are used Register

Usage:
    This sample one command, which reacts to its trackers:

    _TRACKERDEMO "Tracker demo"
        This command creates a rectangle, which the user is prompted to
        insert, scale and rotate.

Overview:
    Functionality:
        We want to draw your attention to the _TRACKERDEMO's command body
        and tracker event:
        * CommandTrackerDemo::ExecuteNotify()
        * CommandTrackerDemo::UpdateNotify(dsMathPoint_c *CursorPosition)

    Command classes:
        Both commands derive from CommandBase. This base class provides an
        interface for both, registering a command to be used from the
        command line via CommandBase::registerCommand() as well as putting
        a command into a menu item via CommandBase::createUserCommand(), so
        done in TrackerDemoApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.
        
Notable hooks and dsAPI functions used:
        TrackerUpdateNotifyHook
        dsApplication_c::put_TemporaryEntityMode()
        dsCommandMessage_c::AddTracker()
        dsCommandMessage_c::RemoveTracker()
        dsTracker_c::AddTemporaryEntity()
        dsTracker_c::RemoveTemporaryEntity()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "TrackerDemo_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of ContextMenuApplication.
// 3 - Go to bool ContextMenuApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandTrackerDemo.h"

class TrackerDemo_EXPORT TrackerDemoApplication
{
public:
    TrackerDemoApplication(dsApplication_c *dsApp) : application(dsApp) {}
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandTrackerDemo m_CommandTrackerDemo;
};

#endif // DS_ADDIN_CONNECTION_H
