//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2017 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayerStateManager.js, JavaScript API dsLayerStateManager interface
//

djObjectExtendCollection.dsLayerStateManager = djLayerStateManagerExtend;

function djLayerStateManagerExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.GetLayerStates = function() {return djProcessCommand(this, 'GetLayerStates', arguments); };
	dsObj.RemoveLayerState = function(LayerStateName) {return djProcessCommand(this, 'RemoveLayerState', arguments); };
	dsObj.CreateLayerState = function(LayerStateName, LayerStateType) {return djProcessCommand(this, 'CreateLayerState', arguments); };
	dsObj.GetActiveLayerState = function() {return djProcessCommand(this, 'GetActiveLayerState', arguments); };
	dsObj.ImportLayerState = function(FilePathName, Overwrite) {return djProcessCommand(this, 'ImportLayerState', arguments); };
	dsObj.ExportLayerState = function(LayerStateName, FilePathName) {return djProcessCommand(this, 'ExportLayerState', arguments); };
	dsObj.get_HideLayersNotAssignedToLayerState = function() {return djProcessCommand(this, 'get_HideLayersNotAssignedToLayerState', arguments); };
	dsObj.put_HideLayersNotAssignedToLayerState = function(NewVal) {return djProcessCommand(this, 'put_HideLayersNotAssignedToLayerState', arguments); };
	dsObj.get_SetPropertiesAsViewPortOverrides = function() {return djProcessCommand(this, 'get_SetPropertiesAsViewPortOverrides', arguments); };
	dsObj.put_SetPropertiesAsViewPortOverrides = function(NewVal) {return djProcessCommand(this, 'put_SetPropertiesAsViewPortOverrides', arguments); };
	dsObj.GetLayerState = function(LayerStateName) {return djProcessCommand(this, 'GetLayerState', arguments); };
	//Add forward methods above this line
}
