//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2017 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSketchManager.js, JavaScript API dsSketchManager interface
//

djObjectExtendCollection.dsSketchManager = djSketchManagerExtend;

function djSketchManagerExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.InsertExternalReference = function(PathName, InsertX, InsertY, InsertZ, Scale, Rotation) {return djProcessCommand(this, 'InsertExternalReference', arguments); };
	dsObj.InsertBlock = function(BlockName, InsertX, InsertY, InsertZ, Scale, Rotation) {return djProcessCommand(this, 'InsertBlock', arguments); };
	dsObj.InsertPicture = function(PathName, InsertX, InsertY, InsertZ, Scale, Rotation) {return djProcessCommand(this, 'InsertPicture', arguments); };
	dsObj.GetBoundingBox = function() {return djProcessCommand(this, 'GetBoundingBox', arguments); };
	dsObj.InsertLine = function(StartX, StartY, StartZ, EndX, EndY, EndZ) {return djProcessCommand(this, 'InsertLine', arguments); };
	dsObj.InsertCircle = function(CenterX, CenterY, CenterZ, Radius) {return djProcessCommand(this, 'InsertCircle', arguments); };
	dsObj.InsertPoint = function(PointX, PointY, PointZ) {return djProcessCommand(this, 'InsertPoint', arguments); };
	dsObj.InsertArc = function(CenterX, CenterY, CenterZ, Radius, StartAngle, EndAngle) {return djProcessCommand(this, 'InsertArc', arguments); };
	dsObj.InsertSimpleNote = function(StartX, StartY, StartZ, Height, Angle, Value) {return djProcessCommand(this, 'InsertSimpleNote', arguments); };
	dsObj.InsertRay = function(StartX, StartY, StartZ, ThroughX, ThroughY, ThroughZ) {return djProcessCommand(this, 'InsertRay', arguments); };
	dsObj.InsertInfiniteLine = function(X1, Y1, Z1, X2, Y2, Z2) {return djProcessCommand(this, 'InsertInfiniteLine', arguments); };
	dsObj.InsertEllipseDistanceToOtherAxis = function(X1, Y1, X2, Y2, DistanceToOtherAxis) {return djProcessCommand(this, 'InsertEllipseDistanceToOtherAxis', arguments); };
	dsObj.InsertEllipseRotation = function(X1, Y1, X2, Y2, Rotation) {return djProcessCommand(this, 'InsertEllipseRotation', arguments); };
	dsObj.InsertEllipseArcDistanceToOtherAxis = function(X1, Y1, X2, Y2, DistanceToOtherAxis, StartAngle, EndAngle) {return djProcessCommand(this, 'InsertEllipseArcDistanceToOtherAxis', arguments); };
	dsObj.InsertEllipseArcRotation = function(X1, Y1, X2, Y2, Rotation, StartAngle, EndAngle) {return djProcessCommand(this, 'InsertEllipseArcRotation', arguments); };
	dsObj.InsertPolyline2D = function(CoordinateDblArray, Closed) {return djProcessCommand(this, 'InsertPolyline2D', arguments); };
	dsObj.InsertNote = function(X1, Y1, Z1, X2, Y2, Z2, StrArray) {return djProcessCommand(this, 'InsertNote', arguments); };
	dsObj.InsertNoteWithParameters = function(X1, Y1, Z1, X2, Y2, Z2, StrArray, Angle, Height, Justify, LineSpacingStyle, LineSpaceDistance, TextStyle, Width) {return djProcessCommand(this, 'InsertNoteWithParameters', arguments); };
	dsObj.InsertRichLine = function(CoordinateDblArray, Justification, Scale, StyleName, Closed) {return djProcessCommand(this, 'InsertRichLine', arguments); };
	dsObj.InsertAngularDimension3Point = function(CenterPointDblArray, AngleStartPointDblArray, AngleEndPointDblArray, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertAngularDimension3Point', arguments); };
	dsObj.InsertAngularDimensionArc = function(Arc, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertAngularDimensionArc', arguments); };
	dsObj.InsertAngularDimension2Line = function(Line1, Line2, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertAngularDimension2Line', arguments); };
	dsObj.InsertAlignedDimension = function(ExtensionLine1PointDblArray, ExtensionLine2PointDblArray, DimensionLinePointDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertAlignedDimension', arguments); };
	dsObj.InsertRotatedDimension = function(ExtensionLine1PointDblArray, ExtensionLine2PointDblArray, DimensionLinePointDblArray, DimensionTextOverride, RotationAngle) {return djProcessCommand(this, 'InsertRotatedDimension', arguments); };
	dsObj.InsertArcLengthDimension = function(Arc, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertArcLengthDimension', arguments); };
	dsObj.InsertArcLengthDimensionPartial = function(Arc, FirstPointDblArray, SecondPointDblArray, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertArcLengthDimensionPartial', arguments); };
	dsObj.InsertDiameterDimensionArc = function(Arc, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertDiameterDimensionArc', arguments); };
	dsObj.InsertDiameterDimensionCircle = function(Circle, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertDiameterDimensionCircle', arguments); };
	dsObj.InsertRadialDimensionArc = function(Arc, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertRadialDimensionArc', arguments); };
	dsObj.InsertRadialDimensionCircle = function(Circle, DimensionPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertRadialDimensionCircle', arguments); };
	dsObj.InsertJoggedDimensionArc = function(CircleArc, CenterPositionOverrideDblArray, JogLinePositionDblArray, DimensionTextPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertJoggedDimensionArc', arguments); };
	dsObj.InsertJoggedDimensionCircle = function(Circle, CenterPositionOverrideDblArray, JogLinePositionDblArray, DimensionTextPositionDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertJoggedDimensionCircle', arguments); };
	dsObj.InsertOrdinateDimension = function(DatumPositionDblArray, DimensionPositionDblArray, DimensionTextOverride, Measure) {return djProcessCommand(this, 'InsertOrdinateDimension', arguments); };
	dsObj.InsertTolerance = function(TolerancePositionDblArray, TextString) {return djProcessCommand(this, 'InsertTolerance', arguments); };
	dsObj.InsertLeader = function(VertexCoordinateDblArray, NoteWidth, NoteText) {return djProcessCommand(this, 'InsertLeader', arguments); };
	dsObj.InsertPolyline3D = function(CoordinateDblArray, Closed) {return djProcessCommand(this, 'InsertPolyline3D', arguments); };
	dsObj.InsertSpline = function(CoordinateDblArray, Closed, StartTangencyX, StartTangencyY, StartTangencyZ, EndTangencyX, EndTangencyY, EndTangencyZ) {return djProcessCommand(this, 'InsertSpline', arguments); };
	dsObj.AttachLinkToArea = function(StartCornerX, StartCornerY, StartCornerZ, OppositeCornerX, OppositeCornerY, OppositeCornerZ, HyperLinkAddress, Description) {return djProcessCommand(this, 'AttachLinkToArea', arguments); };
	dsObj.InsertFace = function(CoordinateDblArray, Edge1Visible, Edge2Visible, Edge3Visible, Edge4Visible) {return djProcessCommand(this, 'InsertFace', arguments); };
	dsObj.InsertSolid = function(CoordinateDblArray) {return djProcessCommand(this, 'InsertSolid', arguments); };
	dsObj.InsertPolygonMesh = function(MVertexCount, NVertexCount, CoordinateDblArray) {return djProcessCommand(this, 'InsertPolygonMesh', arguments); };
	dsObj.InsertPolyFaceMesh = function(VerticesCount, CoordinateDblArray, FaceVerticesCountLongArray, FaceVerticesLongArray) {return djProcessCommand(this, 'InsertPolyFaceMesh', arguments); };
	dsObj.GetEntities = function(Filter, LayerNamesStrArray) {return djProcessCommand(this, 'GetEntities', arguments); };
	dsObj.PatternCircular = function(BasePatternOn, AngleBetween, FillAngle, TotalNumber, ElementBasePointX, ElementBasePointY, AxisPointX, AxisPointY, OrientElementsAboutAxis, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'PatternCircular', arguments); };
	dsObj.PatternLinear = function(NumberElementsOnVerticalAxis, NumberElementsOnHorizontalAxis, SpacingOnVerticalAxis, SpacingOnHorizontalAxis, PatternAngle, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'PatternLinear', arguments); };
	dsObj.CopyEntities = function(DisplacementX, DisplacementY, DisplacementZ, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'CopyEntities', arguments); };
	dsObj.RotateEntities = function(PivotPointX, PivotPointY, RotateAngle, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'RotateEntities', arguments); };
	dsObj.MirrorEntities = function(StartPointOfMirrorLineX, StartPointOfMirrorLineY, StartPointOfMirrorLineZ, EndPointOfMirrorLineX, EndPointOfMirrorLineY, EndPointOfMirrorLineZ, DeleteSourceEntities, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'MirrorEntities', arguments); };
	dsObj.ScaleEntities = function(BasePointX, BasePointY, BasePointZ, ScaleFactor, EntityTypeLongArray, EntitiesArray) {return djProcessCommand(this, 'ScaleEntities', arguments); };
	dsObj.InsertHatchByBoundary = function(BoundaryPointCountLongArray, BoundaryPointDblArray, PatternName, PatternScale, PatternAngle) {return djProcessCommand(this, 'InsertHatchByBoundary', arguments); };
	dsObj.InsertAttributeDefinition = function(Name, Caption, DefaultValue, PositionX, PositionY, PositionZ, TextStyle, Justification, Height, Rotation, Fixed, Hidden, Predefined, Validate, LockInBlock, PositionBelowLastDefinition) {return djProcessCommand(this, 'InsertAttributeDefinition', arguments); };
	dsObj.InsertHatchByEntities = function(EntitiesArray, PatternName, PatternScale, PatternAngle) {return djProcessCommand(this, 'InsertHatchByEntities', arguments); };
	dsObj.InsertHatchByInternalPoints = function(InternalPointsDblArray, PatternName, PatternScale, PatternAngle) {return djProcessCommand(this, 'InsertHatchByInternalPoints', arguments); };
	dsObj.MoveEntities = function(DisplacementX, DisplacementY, DisplacementZ, EntitiesArray) {return djProcessCommand(this, 'MoveEntities', arguments); };
	dsObj.FilletEntities = function(FirstPointOnEntityDblArray, FirstEntityArray, SecondPointOnEntityDblArray, SecondEntityArray) {return djProcessCommand(this, 'FilletEntities', arguments); };
	dsObj.ChamferEntities = function(FirstPointOnEntityDblArray, FirstEntityArray, SecondPointOnEntityDblArray, SecondEntityArray) {return djProcessCommand(this, 'ChamferEntities', arguments); };
	dsObj.TrimEntities = function(CuttingEntitiesArray, EntitiesToRemoveArray, PointOnEntityDblArray) {return djProcessCommand(this, 'TrimEntities', arguments); };
	dsObj.ExtendEntities = function(BoundaryEntitiesArray, EntitiesToExtendArray, PointOnEntityDblArray) {return djProcessCommand(this, 'ExtendEntities', arguments); };
	dsObj.StretchEntities = function(DisplacementX, DisplacementY, DisplacementZ, EntitiesArray, CrossingBoxStartCornerDblArray, CrossingBoxOppositeCornerDblArray) {return djProcessCommand(this, 'StretchEntities', arguments); };
	dsObj.InsertEmbeddedObjectFromFile = function(FilePath, Link, DisplayAsIcon) {return djProcessCommand(this, 'InsertEmbeddedObjectFromFile', arguments); };
	dsObj.IsObjectErased = function(Obj) {return djProcessCommand(this, 'IsObjectErased', arguments); };
	dsObj.SetObjectErased = function(Obj, Value) {return djProcessCommand(this, 'SetObjectErased', arguments); };
	dsObj.GetObjectLayer = function(Obj) {return djProcessCommand(this, 'GetObjectLayer', arguments); };
	dsObj.SetObjectLayer = function(Obj, Layer) {return djProcessCommand(this, 'SetObjectLayer', arguments); };
	dsObj.IsObjectVisible = function(Obj) {return djProcessCommand(this, 'IsObjectVisible', arguments); };
	dsObj.SetObjectVisible = function(Obj, Visible) {return djProcessCommand(this, 'SetObjectVisible', arguments); };
	dsObj.InsertArcByCenter2Points = function(CenterPointsDblArray, FirstPointsDblArray, SecondPointsDblArray) {return djProcessCommand(this, 'InsertArcByCenter2Points', arguments); };
	dsObj.InsertRegion = function(EntitiesArray) {return djProcessCommand(this, 'InsertRegion', arguments); };
	dsObj.InsertBlock2 = function(BlockName, InsertX, InsertY, InsertZ, ScaleX, ScaleY, ScaleZ, Rotation) {return djProcessCommand(this, 'InsertBlock2', arguments); };
	dsObj.InsertTable = function(Left, Top, Rows, Columns, RowHeight, ColumnWidth, FirstRowStyle, SecondRowStyle, OtherRowStyle) {return djProcessCommand(this, 'InsertTable', arguments); };
	dsObj.InsertCircleBy3Points = function(FirstPoint, SecondPoint, ThirdPoint) {return djProcessCommand(this, 'InsertCircleBy3Points', arguments); };
	dsObj.InsertCircleByDiameter = function(CenterX, CenterY, CenterZ, Diameter) {return djProcessCommand(this, 'InsertCircleByDiameter', arguments); };
	dsObj.InsertArcBy3Points = function(FirstPoint, SecondPoint, ThirdPoint) {return djProcessCommand(this, 'InsertArcBy3Points', arguments); };
	dsObj.InsertArcByCenter2Points2 = function(CenterPoint, FirstPoint, SecondPoint) {return djProcessCommand(this, 'InsertArcByCenter2Points2', arguments); };
	dsObj.InsertLinearDimension = function(ExtensionLine1PointDblArray, ExtensionLine2PointDblArray, DimensionLinePointDblArray, DimensionTextOverride) {return djProcessCommand(this, 'InsertLinearDimension', arguments); };
	dsObj.AddTemporaryEntity = function(Entity) {return djProcessCommand(this, 'AddTemporaryEntity', arguments); };
	dsObj.DetachExternalReference = function(ExternalReference) {return djProcessCommand(this, 'DetachExternalReference', arguments); };
	dsObj.AlignEntities1Point = function(SourcePoint, DestinationPoint, EntitiesArray) {return djProcessCommand(this, 'AlignEntities1Point', arguments); };
	dsObj.AlignEntities2Point = function(FirstSourcePoint, FirstDestinationPoint, SecondSourcePoint, SecondDestinationPoint, ScaleEntities, EntitiesArray) {return djProcessCommand(this, 'AlignEntities2Point', arguments); };
	dsObj.BringToFrontEntities = function(EntitiesArray) {return djProcessCommand(this, 'BringToFrontEntities', arguments); };
	dsObj.SendToBackEntities = function(EntitiesArray) {return djProcessCommand(this, 'SendToBackEntities', arguments); };
	dsObj.BringAboveEntities = function(EntitiesArray, ReferenceEntitiesArray) {return djProcessCommand(this, 'BringAboveEntities', arguments); };
	dsObj.SendToUnderEntities = function(EntitiesArray, ReferenceEntitiesArray) {return djProcessCommand(this, 'SendToUnderEntities', arguments); };
	dsObj.AlignEntities3Point = function(FirstSourcePoint, FirstDestinationPoint, SecondSourcePoint, SecondDestinationPoint, ThirdSourcePoint, ThirdDestinationPoint, EntitiesArray) {return djProcessCommand(this, 'AlignEntities3Point', arguments); };
	dsObj.Rotate3DEntities = function(FirstAxisThroughPoint, SecondAxisThroughPoint, Angle, EntitiesArray) {return djProcessCommand(this, 'Rotate3DEntities', arguments); };
	dsObj.Mirror3DEntities = function(FirstPointOnMirrorPlane, SecondPointOnMirrorPlane, ThirdPointOnMirrorPlane, DeleteSourceEntities, EntitiesArray) {return djProcessCommand(this, 'Mirror3DEntities', arguments); };
	dsObj.Align3DEntities = function(FirstBasePoint, SecondBasePoint, ThirdBasePoint, FirstDestinationPoint, SecondDestinationPoint, ThirdDestinationPoint, EntitiesArray) {return djProcessCommand(this, 'Align3DEntities', arguments); };
	dsObj.Pattern3DLinear = function(NumberElementsOnVerticalAxis, NumberElementsOnHorizontalAxis, NumberLevels, VerticalSpacing, HorizontalSpacing, SpacingBetweenLevels, EntitiesArray) {return djProcessCommand(this, 'Pattern3DLinear', arguments); };
	dsObj.Pattern3DCircular = function(NumberItemsInPattern, AngleToFill, RotatePatternElements, CenterPoint, SecondPointOnAxis, EntitiesArray) {return djProcessCommand(this, 'Pattern3DCircular', arguments); };
	dsObj.ExplodeEntities = function(EntitiesArray) {return djProcessCommand(this, 'ExplodeEntities', arguments); };
	dsObj.InsertShape = function(Name, PositionX, PositionY, PositionZ, Height, Rotation) {return djProcessCommand(this, 'InsertShape', arguments); };
	dsObj.DetachReferenceImage = function(ReferenceImage) {return djProcessCommand(this, 'DetachReferenceImage', arguments); };
	dsObj.InsertTrace = function(CoordinateDblArray) {return djProcessCommand(this, 'InsertTrace', arguments); };
	dsObj.FilletPolyLine = function(PolyLine) {return djProcessCommand(this, 'FilletPolyLine', arguments); };
	dsObj.ChamferPolyLine = function(PolyLine) {return djProcessCommand(this, 'ChamferPolyLine', arguments); };
	dsObj.InsertAttributeDefinition2 = function(Name, Caption, DefaultValue, PositionX, PositionY, PositionZ, TextStyle, Justification, Height, Rotation, Fixed, Hidden, Predefined, Validate, LockInBlock, PositionBelowLastDefinition, Multilines) {return djProcessCommand(this, 'InsertAttributeDefinition2', arguments); };
	dsObj.InsertCurvedText = function(Contents, CircleArc) {return djProcessCommand(this, 'InsertCurvedText', arguments); };
	//Add forward methods above this line
}
