//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsAlignedDimension_c.h, C++ API dsAlignedDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsAlignedDimension_p;
class dsAlignedDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsAlignedDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsAlignedDimension)
public:
	DSRESULT IsSame(dsAlignedDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetExtensionLine1Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine1Point(double  X, double  Y, double  Z);
	DSRESULT GetExtensionLine2Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine2Point(double  X, double  Y, double  Z);
	DSRESULT GetDimensionLinePoint(double * X, double * Y, double * Z);
	DSRESULT SetDimensionLinePoint(double  X, double  Y, double  Z);
	DSRESULT get_ObliquingAngle(double * Val);
	DSRESULT put_ObliquingAngle(double  Val);
};
