//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsApplicationOptions_c.h, C++ API dsApplicationOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsApplicationOptions_p;
class dsApplicationOptions;
class dsColor_c;
class DSINTERFACE_EXPORT dsApplicationOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsApplicationOptions)
public:
	DSRESULT IsSame(dsApplicationOptions_c* dsObj);

	DSRESULT GetElementColor(dsElementColor_e  ElementColor, dsColor_c ** Color);
	DSRESULT SetElementColor(dsElementColor_e  ElementColor, dsColor_c * Color);
	DSRESULT GetApplicationOptionBool(dsApplicationOptionBool_e  Var, bool * Value, dsGetApplicationOptionResult_e*  Result);
	DSRESULT SetApplicationOptionBool(dsApplicationOptionBool_e  Var, bool  Value, dsSetApplicationOptionResult_e*  Result);
	DSRESULT GetApplicationOptionInt16(dsApplicationOptionInt16_e  Var, long * Value, dsGetApplicationOptionResult_e*  Result);
	DSRESULT SetApplicationOptionInt16(dsApplicationOptionInt16_e  Var, long  Value, dsSetApplicationOptionResult_e*  Result);
	DSRESULT GetApplicationOptionInt32(dsApplicationOptionInt32_e  Var, long * Value, dsGetApplicationOptionResult_e*  Result);
	DSRESULT SetApplicationOptionInt32(dsApplicationOptionInt32_e  Var, long  Value, dsSetApplicationOptionResult_e*  Result);
	DSRESULT GetApplicationOptionDouble(dsApplicationOptionDouble_e  Var, double*  Value, dsGetApplicationOptionResult_e*  Result);
	DSRESULT SetApplicationOptionDouble(dsApplicationOptionDouble_e  Var, double  Value, dsSetApplicationOptionResult_e*  Result);
	DSRESULT GetApplicationOptionString(dsApplicationOptionString_e  Var, dsString*  Value, dsGetApplicationOptionResult_e*  Result);
	DSRESULT SetApplicationOptionString(dsApplicationOptionString_e  Var, const dsString&  Value, dsSetApplicationOptionResult_e*  Result);
};
