//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsArcAlignedText_c.h, C++ API dsArcAlignedText_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsArcAlignedText_p;
class dsArcAlignedText;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsTransparency_c;
class dsMathLine_c;
class dsMathVector_c;
class dsDictionary_c;
class dsCurvedSettings_c;
class DSINTERFACE_EXPORT dsArcAlignedText_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsArcAlignedText)
public:
	DSRESULT IsSame(dsArcAlignedText_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(dsString NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(dsString NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT GetCurvedTextSettings(dsCurvedSettings_c ** CurvedSettings);
	DSRESULT SetCurvedTextSettings(dsCurvedSettings_c * CurvedSettings);
	DSRESULT GetCenter(double * X, double * Y, double * Z);
	DSRESULT SetCenter(double  X, double  Y, double  Z);
	DSRESULT get_Contents(dsString*  Val);
	DSRESULT put_Contents(const dsString&  NewVal);
	DSRESULT get_Height(double * Val);
	DSRESULT put_Height(double  NewVal);
	DSRESULT get_WidthFactor(double * Val);
	DSRESULT put_WidthFactor(double  NewVal);
	DSRESULT get_CharSpacing(double * Val);
	DSRESULT put_CharSpacing(double  NewVal);
	DSRESULT get_ArcOffset(double * Val);
	DSRESULT put_ArcOffset(double  NewVal);
	DSRESULT get_RightOffset(double * Val);
	DSRESULT put_RightOffset(double  NewVal);
	DSRESULT get_LeftOffset(double * Val);
	DSRESULT put_LeftOffset(double  NewVal);
	DSRESULT get_StartAngle(double * Val);
	DSRESULT put_StartAngle(double  NewVal);
	DSRESULT get_EndAngle(double * Val);
	DSRESULT put_EndAngle(double  NewVal);
	DSRESULT get_Radius(double * Val);
	DSRESULT put_Radius(double  NewVal);
};
