//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCCS_c.h, C++ API dsCCS_c interface
//

#pragma once

#include "dsInterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsCCS_p;
class dsCCS;
class DSINTERFACE_EXPORT dsCCS_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCCS)
public:
	DSRESULT IsSame(dsCCS_c* dsObj);

	DSRESULT GetName(dsString*  Name);
	DSRESULT GetDefaultCSSFlag(bool * IsDefault, dsDefaultCSS_e* dsDefaultCSSFlag);
	DSRESULT GetOrigin(double * OriginX, double * OriginY, double * OriginXZ);
	DSRESULT GetXAxisDirection(double * X, double * Y, double * Z);
	DSRESULT GetYAxisDirection(double * X, double * Y, double * Z);
	DSRESULT GetZAxisDirection(double * X, double * Y, double * Z);
	DSRESULT Rename(const dsString&  NewName, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
};
