//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCommandMessage_c.h, C++ API dsCommandMessage_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsStringArray.h"

class dsCommandMessage_p;
class dsCommandMessage;
class dsMathPlane_c;
class dsMathPoint_c;
class dsTracker_c;

class DSINTERFACE_EXPORT dsCommandMessage_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCommandMessage)
public:
	DSRESULT IsSame(dsCommandMessage_c* Obj);
	DSRESULT PrintLine(const dsString& Str);

	DSRESULT PromptForSelection(bool  SingleSelection, const dsString& Prompt, const dsString&  ErrorMsg, bool * Result);
	DSRESULT PromptForInteger(const dsString&  Prompt, long  DefaultValue, long * Value, bool * Result);
	DSRESULT PromptForDouble(const dsString&  Prompt, double  DefaultValue, double * Value, bool * Result);
	DSRESULT PromptForPoint(const dsString&  Prompt, double * X, double * Y, double * Z, bool * Result);
	DSRESULT PromptForBool(const dsString&  Prompt, const dsString&  StringForTrue, const dsString&  StringForFalse, bool  DefaultValue, bool * Value, bool * Result);
	DSRESULT PromptForString(bool  IgnoreSpaces, const dsString&  Prompt, const dsString&  DefaultString, dsString*  ResultString, bool * Result);
	DSRESULT PromptForDistance(const dsString&  Prompt, double  DefaultValue, double * Value, bool * Result);
	DSRESULT PromptForAngle(const dsString&  Prompt, double  DefaultValue, double * Value, bool * Result);
	DSRESULT PromptForOrientation(const dsString&  Prompt, double  DefaultValue, double * Value, bool * Result);
	DSRESULT PromptForKeyword(const dsString&  Prompt, const dsStringArray&  KeywordsStrArray, const dsString&  DefaultValue, dsString* Value, bool * Result);
	DSRESULT PromptForFileName(const dsString&  Prompt, dsString*  FileName, bool * Result);
	DSRESULT PromptForPoint2(const dsString&  Prompt, bool  ShowRubberLine, double  BasePointX, double  BasePointY, double  BasePointZ, double * X, double * Y, double * Z, dsMathPlane_c * Plane, bool * Result);
	DSRESULT GetLastError(dsRunCommandError_e* Error);
    DSRESULT PromptForBlockInsertion(const dsString& PreviewBlockName, bool SpecifyScale, double DefaultScaleX, double DefaultScaleY, double DefaultScaleZ, bool SpecifyRotation, double DefaultRotation, double * X, double * Y, double * Z, double * ScaleX, double * ScaleY, double * ScaleZ, double * Rotation, dsPromptResultType_e* Result);
	DSRESULT PromptForAngleOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray&  GlobalKeywordStrArray, const dsStringArray&  LocalKeywordStrArray, long PromptInit, double  DefaultValue, dsString*  Keyword, double * Value, dsPromptResultType_e* Result );
	DSRESULT PromptForBoolOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray&  GlobalKeywordStrArray, const dsStringArray&  LocalKeywordStrArray, long  PromptInit, const dsString&  StringForTrue, const dsString&  StringForFalse, bool  DefaultValue, dsString*  Keyword, bool * Value, dsPromptResultType_e* Result );
	DSRESULT PromptForDistanceOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray&  GlobalKeywordStrArray, const dsStringArray&  LocalKeywordStrArray, long  PromptInit, double  DefaultValue, dsString*  Keyword, double * Value, dsPromptResultType_e*  Result );
	DSRESULT PromptForDoubleOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, double  DefaultValue, dsString*  Keyword, double * Value, dsPromptResultType_e*  Result );
	DSRESULT PromptForIntegerOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, long  DefaultValue, dsString*  Keyword, long * Value, dsPromptResultType_e*  Result );
	DSRESULT PromptForOrientationOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, double  DefaultValue, dsString*  Keyword, double * Value, dsPromptResultType_e*  Result );
	DSRESULT PromptForPointOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, bool  ShowRubberLine, dsMathPoint_c * DefaultValue, dsMathPoint_c * BasePoint, dsString*  Keyword, dsMathPoint_c ** ResultPoint, dsMathPlane_c * Plane, dsPromptResultType_e*  Result);
	DSRESULT PromptForSelectionOrKeyword(bool  SingleSelection, const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, dsString*  Keyword, dsPromptResultType_e*  Result );
	DSRESULT PromptForStringOrKeyword(bool  IgnoreSpaces, const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, const dsString&  DefaultString, dsString*  Keyword, dsString*  ResultString, dsPromptResultType_e*  Result );
	DSRESULT PromptForKeyword2(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, const dsString&  DefaultValue, dsString*  Value, dsPromptResultType_e*  Result );
	DSRESULT PromptForFileNameOrKeyword(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, const dsString&  DefaultFileName, dsString*  Keyword, dsString*  FileName, dsPromptResultType_e*  Result );
	DSRESULT AddTracker(dsTracker_c  * Tracker );
	DSRESULT RemoveTracker(dsTracker_c  * Tracker );
	DSRESULT PromptForAngleOrKeyword2(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray , long  PromptInit , bool  ShowRubberLine, double DefaultValue, dsMathPoint_c * BasePoint, dsString*  Keyword, double * Value, dsPromptResultType_e*  Result);
	DSRESULT get_PromptExplanation(dsString*  Val);
	DSRESULT put_PromptExplanation(const dsString&  NewVal);
	DSRESULT PromptForDistanceOrKeyword2(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, bool  ShowRubberLine, double  DefaultValue, dsMathPoint_c * BasePoint, dsString*  Keyword, double * Value, dsPromptResultType_e*  Result);
	DSRESULT PromptForOrientationOrKeyword2(const dsString&  Prompt, const dsString&  ErrorMsg, const dsStringArray &  GlobalKeywordStrArray, const dsStringArray &  LocalKeywordStrArray, long  PromptInit, bool  ShowRubberLine, double  DefaultValue, dsMathPoint_c * BasePoint , dsString*  Keyword, double * Value, dsPromptResultType_e*  Result);
	DSRESULT GetLastUserInput(dsString*  UserInput);
};
