//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsContextMenuItem_c.h, C++ API dsContextMenuItem_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsContextMenuItem_p;
class dsContextMenuItem;
class DSINTERFACE_EXPORT dsContextMenuItem_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsContextMenuItem)
public:
    DSRESULT IsSame(dsContextMenuItem_c* dsObj);
    DSRESULT GetID(dsString* ID);
    DSRESULT GetType(dsMenuItemType_e* ItemType);
    DSRESULT GetContextType(dsContextMenuType_e* ContextType);
    DSRESULT GetObjectType(dsObjectType_e* ObjectType);
    DSRESULT GetCommand(dsString* CmdName);
    DSRESULT Remove();
    DSRESULT GetApiID(dsString*  ApiUuid);
    DSRESULT InsertMenuItem(const dsString& ApiUuid, dsMenuItemType_e ItemType, long Position, const dsString& ItemName, const dsString& UserCmdID, dsContextMenuItem_c** ContextMenuItem);
    DSRESULT GetMenuItems(dsObjectPtrArray* ContextMenuItemArray);
    DSRESULT get_Name(dsString* Val);
    DSRESULT put_Name(const dsString& NewVal);
    DSRESULT get_Enabled(bool* Val);
    DSRESULT put_Enabled(bool NewVal);
};
