//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCurvedSettings_c.h, C++ API dsCurvedSettings_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
class dsColor_c;

class dsCurvedSettings_p;
class dsCurvedSettings;
class DSINTERFACE_EXPORT dsCurvedSettings_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCurvedSettings)
public:
	DSRESULT IsSame(dsCurvedSettings_c* dsObj);

	DSRESULT GetFontParameters(dsString*  Typeface, bool * Bold, bool * Italic, long * Charset, long * PitchAndFamily);
	DSRESULT SetFontParameters(const dsString&  Typeface, bool  Bold, bool  Italic, long  Charset, long  PitchAndFamily);
	DSRESULT get_Alignment(dsArcTextAlignment_e*  Val);
	DSRESULT put_Alignment(dsArcTextAlignment_e  NewVal);
	DSRESULT get_Underlined(bool * Val);
	DSRESULT put_Underlined(bool  NewVal);
	DSRESULT get_TextSide(dsArcTextPosition_e*  Val);
	DSRESULT put_TextSide(dsArcTextPosition_e  NewVal);
	DSRESULT get_TextDirection(dsArcTextDirection_e*  Val);
	DSRESULT put_TextDirection(dsArcTextDirection_e  NewVal);
	DSRESULT get_Flip(bool * Val);
	DSRESULT put_Flip(bool  NewVal);
	DSRESULT get_TextStyle(dsString*  Val);
	DSRESULT put_TextStyle(const dsString&  NewVal);
	DSRESULT get_Font(dsString*  Val);
	DSRESULT put_Font(const dsString&  NewVal);
    DSRESULT get_Color(dsColor_c ** Val);
    DSRESULT put_Color(dsColor_c * NewVal);
};
