//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCustomCoordinateSystemManager_c.h, C++ API dsCustomCoordinateSystemManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsStringArray.h"
#include "dsDoubleArray.h"

class dsCustomCoordinateSystemManager_p;
class dsCustomCoordinateSystemManager;
class dsCustomCoordinateSystem_c;
class dsMathPoint_c;
class DSINTERFACE_EXPORT dsCustomCoordinateSystemManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCustomCoordinateSystemManager)
public:
	DSRESULT IsSame(dsCustomCoordinateSystemManager_c* dsObj);

	DSRESULT GetWorldCustomCoordinateSystem(dsCustomCoordinateSystem_c ** CustomCoordinateSystem);
	DSRESULT GetPreviousCustomCoordinateSystem(dsCustomCoordinateSystem_c ** CustomCoordinateSystem);
	DSRESULT GetNamedCustomCoordinateSystemList(dsStringArray * CustomCoordinateSystemNamesStrArray);
	DSRESULT GetNamedCustomCoordinateSystem(const dsString&  CSSName, dsCustomCoordinateSystem_c ** CustomCoordinateSystem);
	DSRESULT RemoveCustomCoordinateSystem(const dsString&  CustomCoordinateSystemName, bool * Result);
	DSRESULT GetActiveCustomCoordinateSystem(dsCustomCoordinateSystem_c ** CustomCoordinateSystem);
	DSRESULT GetDefaultCustomCoordinateSystem(dsDefaultCustomCoordinateSystem_e DefaultCustomCoordinateSystem, dsCustomCoordinateSystem_c ** CustomCoordinateSystem);
	DSRESULT AlignActiveCustomCoordinateSystemByEntity(dsObject * Entity, const dsDoubleArray& PointOnEntityDblArray);
	DSRESULT AlignActiveCustomCoordinateSystemByView( );
	DSRESULT SetActiveCustomCoordinateSystemOrigin(double  OriginX, double  OriginY, double  OriginZ);
	DSRESULT AlignActiveCustomCoordinateSystemZAxis(double  OriginX, double  OriginY, double  OriginZ, double  DirectionX, double  DirectionY, double  DirectionZ);
	DSRESULT SaveActiveViewAs(const dsString&  Name, dsCustomCoordinateSystem_c ** CustomCoordinateSystem, dsCreateObjectResult_e* Result);
	DSRESULT AlignActiveCustomCoordinateSystemXYPlane(dsMathPoint_c * Origin, dsMathPoint_c * XAxisThroughPoint, dsMathPoint_c * XYPlaneThroughPoint);
};
