//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCustomPropertyControl_c.h, C++ API dsCustomPropertyControl_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsCustomPropertyControl_p;
class dsCustomPropertyControl;
class DSINTERFACE_EXPORT dsCustomPropertyControl_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCustomPropertyControl)
public:
	DSRESULT IsSame(dsCustomPropertyControl_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
	//DSRESULT put_Name(const dsString&  NewVal);
	DSRESULT GetHWND(long * HWND);
	DSRESULT get_Visible(bool * Val);
	DSRESULT put_Visible(bool  NewVal);
	DSRESULT RegisterEvent(dsCustomPropertyControlEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT UnRegisterEvent(dsCustomPropertyControlEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT GetSize(long * Width, long * Height);
	DSRESULT Destroy( );
};


class dsCustomPropertyControlEvents_c
{
public:
	virtual bool SizeChangedNotify() {return true;}
};



#define DeclareCustomPropertyControlSizeChangedNotifyHook static bool SizeChangedNotifyHook(void* eventClassPtr);

#define ImplementCustomPropertyControlSizeChangedNotifyHook(EventClass)\
bool EventClass::SizeChangedNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->SizeChangedNotify(); \
}


#define RegisterCustomPropertyControlSizeChangedNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsCustomPropertyControl_SizeChangedNotify_id, this, (void *) SizeChangedNotifyHook);


#define UnRegisterCustomPropertyControlSizeChangedNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsCustomPropertyControl_SizeChangedNotify_id, this, (void *) SizeChangedNotifyHook);


