//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDSWindow_c.h, C++ API dsDSWindow_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDSWindow_p;
class dsDSWindow;
class DSINTERFACE_EXPORT dsDSWindow_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDSWindow)
public:
	DSRESULT IsSame(dsDSWindow_c* dsObj);

	DSRESULT GetHWND(long * HWND);
	DSRESULT GetFramePosition(long * X, long * Y);
	DSRESULT SetFramePosition(long  X, long  Y);
	DSRESULT GetFrameSize(long * Height, long * Width);
	DSRESULT SetFrameSize(long  Height, long  Width);
	DSRESULT GetGeometryPosition(long * X, long * Y);
	DSRESULT SetGeometryPosition(long  X, long  Y);
	DSRESULT GetGeometrySize(long * Height, long * Width);
	DSRESULT SetGeometrySize(long  Height, long  Width);
	DSRESULT get_Visible(bool * Val);
	DSRESULT put_Visible(bool  NewVal);
	DSRESULT get_WindowState(dsWindowState_e* Val);
	DSRESULT put_WindowState(dsWindowState_e NewVal);
};
