//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDiameterDimension_c.h, C++ API dsDiameterDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDiameterDimension_p;
class dsDiameterDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsDiameterDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDiameterDimension)
public:
	DSRESULT IsSame(dsDiameterDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetDefiningPoint(double * X, double * Y, double * Z);
	DSRESULT SetDefiningPoint(double  X, double  Y, double  Z);
	DSRESULT GetFarDefiningPoint(double * X, double * Y, double * Z);
	DSRESULT SetFarDefiningPoint(double  X, double  Y, double  Z);
	DSRESULT get_LeaderLength(double * Val);
	DSRESULT put_LeaderLength(double  NewVal);
};
