//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleDualDimensionOptions_c.h, C++ API dsDimensionStyleDualDimensionOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleDualDimensionOptions_p;
class dsDimensionStyleDualDimensionOptions;
class DSINTERFACE_EXPORT dsDimensionStyleDualDimensionOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleDualDimensionOptions)
public:
	DSRESULT IsSame(dsDimensionStyleDualDimensionOptions_c* dsObj);

	DSRESULT get_Show(bool * Val);
	DSRESULT put_Show(bool  NewVal);
	DSRESULT get_Format(dsDualDimensionFormat_e* Val);
	DSRESULT put_Format(dsDualDimensionFormat_e NewVal);
	DSRESULT get_Precision(dsUnitPrecision_e* Val);
	DSRESULT put_Precision(dsUnitPrecision_e NewVal);
	DSRESULT get_MultiplierForConvertingUnits(double * Val);
	DSRESULT put_MultiplierForConvertingUnits(double  NewVal);
	DSRESULT get_RoundToTheNearest(double * Val);
	DSRESULT put_RoundToTheNearest(double  NewVal);
	DSRESULT get_Prefix(dsString*  Val);
	DSRESULT put_Prefix(const dsString&  NewVal);
	DSRESULT get_Suffix(dsString*  Val);
	DSRESULT put_Suffix(const dsString&  NewVal);
	DSRESULT get_HideLeadingZeroes(bool * Val);
	DSRESULT put_HideLeadingZeroes(bool  NewVal);
	DSRESULT get_HideTrailingZeroes(bool * Val);
	DSRESULT put_HideTrailingZeroes(bool  NewVal);
	DSRESULT get_HideZeroesIf0Feet(bool * Val);
	DSRESULT put_HideZeroesIf0Feet(bool  NewVal);
	DSRESULT get_HideZeroesIf0Inches(bool * Val);
	DSRESULT put_HideZeroesIf0Inches(bool  NewVal);
	DSRESULT get_Insertion(dsDualDimensionInsertPlacement_e* Val);
	DSRESULT put_Insertion(dsDualDimensionInsertPlacement_e NewVal);
};
