//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleManager_c.h, C++ API dsDimensionStyleManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleManager_p;
class dsDimensionStyleManager;
class dsDimensionStyle_c;
class DSINTERFACE_EXPORT dsDimensionStyleManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleManager)
public:
	DSRESULT IsSame(dsDimensionStyleManager_c* dsObj);

	DSRESULT CreateDimensionStyle(const dsString&  Name, dsDimensionStyle_c ** DimensionStyle, dsCreateObjectResult_e* Result);
	DSRESULT GetDimensionStyle(const dsString&  Name, dsDimensionStyle_c ** DimensionStyle);
	DSRESULT GetDimensionStyles(dsObjectPtrArray * DimensionStyleArray);
	DSRESULT RemoveDimensionStyle(const dsString&  Name, bool * Result);
	DSRESULT GetActiveDimensionStyle(dsDimensionStyle_c ** DimensionStyle);
};
