//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleTextOptions_c.h, C++ API dsDimensionStyleTextOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleTextOptions_p;
class dsDimensionStyleTextOptions;
class dsColor_c;
class DSINTERFACE_EXPORT dsDimensionStyleTextOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleTextOptions)
public:
	DSRESULT IsSame(dsDimensionStyleTextOptions_c* dsObj);

	DSRESULT get_Style(dsString*  Val);
	DSRESULT put_Style(const dsString&  NewVal);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_FillColor(dsColor_c ** Val);
	DSRESULT put_FillColor(dsColor_c * NewVal);
	DSRESULT get_Height(double * Val);
	DSRESULT put_Height(double  NewVal);
	DSRESULT get_FractionalScale(double * Val);
	DSRESULT put_FractionalScale(double  NewVal);
	DSRESULT get_FrameDimensionText(bool * Val);
	DSRESULT put_FrameDimensionText(bool  NewVal);
	DSRESULT get_HorizontalPosition(dsDimensionTextHorizontalPosition_e* Val);
	DSRESULT put_HorizontalPosition(dsDimensionTextHorizontalPosition_e NewVal);
	DSRESULT get_VerticalPosition(dsDimensionTextVerticalPosition_e* Val);
	DSRESULT put_VerticalPosition(dsDimensionTextVerticalPosition_e NewVal);
	DSRESULT get_OffsetFromDimensionLines(double * Val);
	DSRESULT put_OffsetFromDimensionLines(double  NewVal);
	DSRESULT get_Alignment(dsDimensionTextAlignment_e* Val);
	DSRESULT put_Alignment(dsDimensionTextAlignment_e NewVal);
};
