//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleToleranceOptions_c.h, C++ API dsDimensionStyleToleranceOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDimensionStyleToleranceOptions_p;
class dsDimensionStyleToleranceOptions;
class DSINTERFACE_EXPORT dsDimensionStyleToleranceOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleToleranceOptions)
public:
	DSRESULT IsSame(dsDimensionStyleToleranceOptions_c* dsObj);

	DSRESULT get_Calculation(dsToleranceCalculation_e* Val);
	DSRESULT put_Calculation(dsToleranceCalculation_e NewVal);
	DSRESULT get_Precision(dsUnitPrecision_e* Val);
	DSRESULT put_Precision(dsUnitPrecision_e NewVal);
	DSRESULT get_MaximumValue(double * Val);
	DSRESULT put_MaximumValue(double  NewVal);
	DSRESULT get_MinimumValue(double * Val);
	DSRESULT put_MinimumValue(double  NewVal);
	DSRESULT get_Scale(double * Val);
	DSRESULT put_Scale(double  NewVal);
	DSRESULT get_VerticalTextJustification(dsToleranceVerticalTextJustification_e* Val);
	DSRESULT put_VerticalTextJustification(dsToleranceVerticalTextJustification_e NewVal);
	DSRESULT get_HideLeadingZeroes(bool * Val);
	DSRESULT put_HideLeadingZeroes(bool  NewVal);
	DSRESULT get_HideTrailingZeroes(bool * Val);
	DSRESULT put_HideTrailingZeroes(bool  NewVal);
	DSRESULT get_HideZeroesIf0Feet(bool * Val);
	DSRESULT put_HideZeroesIf0Feet(bool  NewVal);
	DSRESULT get_HideZeroesIf0Inches(bool * Val);
	DSRESULT put_HideZeroesIf0Inches(bool  NewVal);
	DSRESULT get_DualDimensionPrecision(dsUnitPrecision_e* Val);
	DSRESULT put_DualDimensionPrecision(dsUnitPrecision_e NewVal);
	DSRESULT get_DualDimensionHideLeadingZeroes(bool * Val);
	DSRESULT put_DualDimensionHideLeadingZeroes(bool  NewVal);
	DSRESULT get_DualDimensionHideTrailingZeroes(bool * Val);
	DSRESULT put_DualDimensionHideTrailingZeroes(bool  NewVal);
	DSRESULT get_DualDimensionHideZeroesIf0Feet(bool * Val);
	DSRESULT put_DualDimensionHideZeroesIf0Feet(bool  NewVal);
	DSRESULT get_DualDimensionHideZeroesIf0Inches(bool * Val);
	DSRESULT put_DualDimensionHideZeroesIf0Inches(bool  NewVal);
	DSRESULT get_ScaleTolerance(double * Val);
	DSRESULT put_ScaleTolerance(double  NewVal);
};
