//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDrawingSupportFiles_c.h, C++ API dsDrawingSupportFiles_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDrawingSupportFiles_p;
class dsDrawingSupportFiles;
class DSINTERFACE_EXPORT dsDrawingSupportFiles_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDrawingSupportFiles)
public:
	DSRESULT IsSame(dsDrawingSupportFiles_c* dsObj);

    DSRESULT get_AlternateShxFontFile(dsString*  Val);
    DSRESULT put_AlternateShxFontFile(const dsString&  NewVal);
    DSRESULT get_AlternateBigFontFile(dsString*  Val);
    DSRESULT put_AlternateBigFontFile(const dsString&  NewVal);
    DSRESULT get_AlternateShapeFile(dsString*  Val);
    DSRESULT put_AlternateShapeFile(const dsString&  NewVal);
    DSRESULT get_DrawingFilesPath(dsStringArray * StrArray);
    DSRESULT put_DrawingFilesPath(const dsStringArray& NewStrArray);
    DSRESULT get_DrawingTemplateFilesPath(dsString*  Val);
    DSRESULT put_DrawingTemplateFilesPath(const dsString&  NewVal);
    DSRESULT get_ExternalReferencesFilesPath(dsString*  Val);
    DSRESULT put_ExternalReferencesFilesPath(const dsString&  NewVal);
    DSRESULT get_FontMappingFile(dsString*  Val);
    DSRESULT put_FontMappingFile(const dsString&  NewVal);
    DSRESULT get_LibraryFilesPath(dsString*  Val);
    DSRESULT put_LibraryFilesPath(const dsString&  NewVal);
    DSRESULT get_LineStyleFilePath(dsString*  Val);
    DSRESULT put_LineStyleFilePath(const dsString&  NewVal);
    DSRESULT get_PrintSettingsPath(dsString*  Val);
    DSRESULT put_PrintSettingsPath(const dsString&  NewVal);
    DSRESULT get_RichLineStyleFilePath(dsString*  Val);
    DSRESULT put_RichLineStyleFilePath(const dsString&  NewVal);

};
