//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsEntityHelper_c.h, C++ API dsEntityHelper_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsEntityHelper_p;
class dsEntityHelper;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsDictionary_c;
class dsTransparency_c;
class DSINTERFACE_EXPORT dsEntityHelper_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsEntityHelper)
public:
	DSRESULT IsSame(dsEntityHelper_c* dsObj);

	DSRESULT GetColor(dsObject * Obj, dsColor_c ** Val);
	DSRESULT SetColor(dsObject * Obj, dsColor_c * NewVal);

    DSRESULT GetLayer(dsObject* Obj, dsString* Val);
	DSRESULT SetLayer(dsObject* Obj, const dsString& NewVal);
	DSRESULT GetLineStyle(dsObject * Obj, dsString*  Val);
	DSRESULT SetLineStyle(dsObject * Obj, const dsString&  Val);
	DSRESULT GetVisible(dsObject * Obj, bool * Val);
	DSRESULT SetVisible(dsObject * Obj, bool  NewVal);
	DSRESULT GetLineWeight(dsObject * Obj, dsLineWeight_e* Val);
	DSRESULT SetLineWeight(dsObject * Obj, dsLineWeight_e NewVal);
	DSRESULT GetCustomData(dsObject * Obj, const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(dsObject * Obj, const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT Select(dsObject * Obj, bool  SelectFlag, bool * Res);
	DSRESULT GetHyperLink(dsObject * Obj, dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsObject * Obj, dsHyperLink_c * HyperLink);
	DSRESULT DeleteCustomData(dsObject * Obj, const dsString&  ApplicationName);
	DSRESULT DeleteHyperLink(dsObject * Obj);
    DSRESULT CompareObjects(dsObject * Obj1, dsObject * Obj2, bool * Result);
	DSRESULT GetHandle(dsObject * Obj, dsString*  Val);
	DSRESULT GetErased(dsObject * Obj, bool * Val);
	DSRESULT SetErased(dsObject * Obj, bool  NewVal);
	DSRESULT CreateExtensionDictionary(dsObject * Obj, dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsObject * Obj, dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(dsObject * Obj, bool * Result);
	DSRESULT GetPrintStyle(dsObject * Obj, dsString*  Val);
	DSRESULT SetPrintStyle(dsObject * Obj, const dsString&  Val);
	DSRESULT GetTransparency(dsObject * Obj, dsTransparency_c ** Val);
	DSRESULT SetTransparency(dsObject * Obj, dsTransparency_c * Val);
};
