//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsExternalReference_c.h, C++ API dsExternalReference_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsBlockDefinition_c;
class dsExternalReference_p;
class dsExternalReference;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsExternalReference_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsExternalReference)
public:
	DSRESULT IsSame(dsExternalReference_c* Obj);
	DSRESULT get_Name(dsString* Val);
	DSRESULT put_Name(const dsString& NewVal);
	DSRESULT get_PathName(dsString* Val);
	DSRESULT put_PathName(const dsString& NewVal);
	DSRESULT Reload(void);
	DSRESULT Unload(void);
	DSRESULT GetBlockDefinition(dsBlockDefinition_c** BlockDef);
	DSRESULT GetParents(dsObjectPtrArray* ExternalReferenceArray);
	DSRESULT GetChildren(dsObjectPtrArray* ExternalReferenceArray);
	DSRESULT GetFoundInPath(dsString* Path);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT IsTopLevel(bool * IsTopLevel);
};
